% Periodogram .. figure 10
% mww, 8/12/2015
% 
clear all;
small = 1.0e-10;

% -- File Directories   
outdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/out/';
figdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/fig/';
matdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/mat/';

load_data = 1;
wc15_data_calendar;

Xstr = 'dln_gdp';
%Xstr = 'dln_p';
nper = 4;
sfirst = [1947 2];  % First obs to use (truncated if later)
slast = [2014 4];   % Last Obs to use (truncated if earlier)

eval(['X_raw = ' Xstr ';']);

% Save series over desired sample period
tmp = packr([calvec X_raw]);
calvec = tmp(:,1);
X_raw = tmp(:,2);
ismpl = smpl(calvec,sfirst,slast,nper);
calvec = calvec(ismpl==1);
dnobs = size(calvec,1);
X_raw = X_raw(ismpl==1);

X = X_raw - mean(X_raw);
[pd,w]=periodogram(X,[],dnobs);

ha = area([0 2*pi/44],[50 50]);
set( ha, 'FaceColor', 'y')
hold on;
plot(w,pd,'*b','MarkerSize',10,'LineWidth',4);
hold off;
xlabel('Frequency');
ax = gca;
ax.FontSize = 30;
% ax.XLim = [0.0001 pi];
% ax.Ylim = [0 50];

 
 
     
         
 
 

 
 
     
     
 
     
  


         
     
 
  
  
  