function [Sigma,ier] = Sigma_Compute(b,c,d,q,iconst)
% Compute Sigma for "b,c,d" model for q cosine transforms

 % Approximation are based on T "sample" observations 
 %    Use Small T for general model because it requires evaluation of
 %    hypergeometric which is slow and relatively innacurate for large T
 %    (Note ... try to modify this finding alternative approxiamation).
 %    Large T is fine for special cases.
 %    ier = 0 (no problems); ier = 1 (negative eigenvalue, corrected)
 %    iconst = 1; include mean (0'th cosine transform)
 T_general = 150;
 T_special = 600;
 
 % -------------  Step 1; Compute Covariance Matrix for I(d) Component 
    % A. Compute I(d) Component ... look at some special Cases
     if c < .00001;  % Use fractional model
        T = T_special;
        cov_Id = frac_cov(T,d);
     else;
        if d == 1;    % AR(1) Model with Zero Initial Condition
             T = T_special;
             rho = 1 - c/T;
             rho = max([0;rho]);
             cov_Id = AR1_cov(T,rho);
        else;
             T = T_general;
             rho = 1 - c/T;
             rho = max([0;rho]);
             cov_Id = frac_dif_cov(T,rho,d);
        end;
     end;
    % -- B. Add I(0) Components  
     scale_I0 = (b*(T^d))^2;         % Scale for I(0) component
     covmat = cov_Id + scale_I0*eye(T);   
     
 % ------------------ Step 2: Compute PSI Matrix and Extension for xbar(t+1:t+h)
   psi = psi_compute(T,q); % Cosine Transformations
   if iconst == 1;
       psi = [ones(T,1)/T psi];
   end;
  
 % ---------------- Step 3: Compute Sigma
   Sigma = psi'*covmat*psi;
   Sigma = (T^(1-2*d))*Sigma;
   
 % ---------------- Step 4: Verify that Sigma is PD
   ier = 0;
   tmp = eig(Sigma);
   if min(tmp) < 0;
       ier = 1;
       %fprintf('... Estimated Sigma has negative eigenvalue \n')
       %fprintf('b,c,d = %6.4f,%6.2f,%6.2f \n',b,c,d)
       %fprintf('     ....... Correcting Matrix .....\n ');
       Sigma_2 = Sigma*Sigma';
       [V,D2]=eig(Sigma_2);
       D_vec = sqrt(diag(D2));
       D_mat = diag(D_vec);
       Sigma = V*D_mat*V';
   end;
       
   
end

