function [lfur,lfur_pvalue] = lfur_pv(X,c)
% compute LFUR statistic and pvalue
% X  = cosine transforms
% c = value of c under alternative
q = size(X,1);
tmp = (1:1:q)';
tmp = (tmp*pi).^2;
cov_ho = 1./tmp;
chol_ho = sqrt(cov_ho);
chol_ho_inv = sqrt(1./cov_ho);
Xo = chol_ho_inv.*X;

[cov_ha,ier] = Sigma_Compute(0,c,1,q,0);
chol_ha_inv = chol(inv(cov_ha));
Xa = chol_ha_inv*X;

lfur = sum(Xo.^2)/sum(Xa.^2);

% Generate 1000 draws under Ho for pvalue calculation
nsim = 50000;
Xsim = randn(q,nsim).*repmat(chol_ho,1,nsim);;
Xosim = Xsim.*repmat(chol_ho_inv,1,nsim);
Xasim = chol_ha_inv*Xsim;
nx = sum(Xosim.^2);
dx = sum(Xasim.^2);
lfur_sim = (nx./dx)';
lfur_pvalue = mean(lfur_sim >= lfur);

end

