% Local-to-Zero Spectra
% mww, 9/3/2015
% 
clear all;
small = 1.0e-10;

% -- File Directories   
outdir = '/Users/mwatson/Dropbox/wc15/matlab/out/';
figdir = '/Users/mwatson/Dropbox/wc15/matlab/fig/';
matdir = '/Users/mwatson/Dropbox/wc15/matlab/mat/';

% Compute Local-to-zero spectra

n = 500;

x = linspace(0.001,15*pi,n)';
y_i0 = ones(n,1);
y_i1 = ones(n,1)./(x.^2);
[tmp,i1]=min(abs(x-6*pi));

figure;
subplot(2,2,1);

% Panel A
yvec = [y_i0 y_i1];
for ib = 1:size(yvec,2);
    yvec(:,ib) = log(yvec(:,ib)/yvec(i1,ib));
end;
w = x/pi;
plot(w,yvec(:,1),'-k','LineWidth',3);
hold on;
for ib = 2:size(yvec,2);
 plot(w,yvec(:,ib),'-k','LineWidth',3);
end;
hold off;
xlabel('Multiples of \pi');
title('(a) I(0) and I(1) Models');
ax = gca;
ax.FontSize = 30;
ax.XLim = [0 15];
%ax.Ylim = [0 15];

% Panel bl
subplot(2,2,2);
bvec = [0 2 10 50]';
yvec = zeros(n,size(bvec,1));
for ib = 1:size(bvec,1);
    b = bvec(ib);
    yvec(:,ib) = y_i0 + (b^2)*y_i1;
    yvec(:,ib) = log(yvec(:,ib)/yvec(i1,ib));
end;

w = x/pi;
plot(w,yvec(:,1),'-k','LineWidth',3);
hold on;
for ib = 2:size(yvec,2);
 plot(w,yvec(:,ib),'-k','LineWidth',3);
end;
hold off;
xlabel('Multiples of \pi');
title('(b) Local-level model');
ax = gca;
ax.FontSize = 30;
ax.XLim = [0 15];

% panel c
subplot(2,2,3);
[tmp,i1]=min(abs(x-6*pi));
cvec = [0 3 10 30]';
yvec = zeros(n,size(cvec,1));
for ib = 1:size(cvec,1);
  c = cvec(ib);
  yvec(:,ib) = ones(n,1)./((x.^2) + (c^2)*ones(n,1));
  yvec(:,ib) = log(yvec(:,ib)/yvec(i1,ib));
end;
w = x/pi;
plot(w,yvec(:,1),'-k','LineWidth',3);
hold on;
for ib = 2:size(yvec,2);
 plot(w,yvec(:,ib),'-k','LineWidth',3);
end;
hold off;
xlabel('Multiples of \pi');
title('(c) Local-to-Unity AR(1) model');
ax = gca;
ax.FontSize = 30;
ax.XLim = [0 15];


% panel (d)
subplot(2,2,4);
[tmp,i1]=min(abs(x-6*pi));
dvec = [-0.333 0 .333 1  1.333]';
yvec = zeros(n,size(dvec,1));
for ib = 1:size(dvec,1);
  d = dvec(ib);
  yvec(:,ib) = (ones(n,1)./(x.^2)).^d;
  yvec(:,ib) = log(yvec(:,ib)/yvec(i1,ib));
end;
w = x/pi;
plot(w,yvec(:,1),'-k','LineWidth',3);
hold on;
for ib = 2:size(yvec,2);
 plot(w,yvec(:,ib),'-k','LineWidth',3);
end;
hold off;
xlabel('Multiples of \pi');
title('(d) Fractional model');
ax = gca;
ax.FontSize = 30;
ax.XLim = [0 15];



 
     
         
 
 

 
 
     
     
 
     
  


         
     
 
  
  
  