% Set up data and calendars for wc15 project
% 9/2/2015, mww

if load_data == 1;

% ----------- Features of Data Set ---------
miss_code = 1.0e+32;

% ----------- Sample Period, Calendars and so forth
% Calendar Vector
nfirst = [1947 1];
nlast = [2015 2];
[dnobs,calvec,calds] = calendar_make(nfirst,nlast,4);

% --------------- Read In quarterly Data ---------------- 
ns = 3;  % Number of Data Series
xlsname = '/Users/mwatson/Dropbox/wc15/ddisk/data/wc15.xlsx';
% Read Data 
ndesc=1;
ncodes=0;
sheet='Quarterly';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
%tcodemat = tcodemat(1,:);
labelvec=descmat(:,1);
% Convert Namestrings to upper case 
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);
labelvec=strtrim(labelvec);
% Replace missing values with NaN
isel = datamat == miss_code;
datamat(isel) = NaN;


% --- Get Series 
  
  str='p_pce';    % PCE Delfator
  str=upper(str);
  j = colnumber(str,namevec);
  p_pce=datamat(:,j);
  
  str='gdp_pc';    % Nominal GDP per Capita
  str=upper(str);
  j = colnumber(str,namevec);
  gdp_pc=datamat(:,j);
  
  str='dtfp';    % Nominal GDP per Capita
  str=upper(str);
  j = colnumber(str,namevec);
  dtfp=datamat(:,j);

  ln_gdp = log(gdp_pc);
  dln_gdp = 400*dif(ln_gdp,1);
  
  ln_p = log(p_pce);
  dln_p = 400*dif(ln_p,1);
  ddln_p = dif(dln_p,1);
    
 % Save Variable Series 
  slist = {...
           'ln_gdp' ... 
           'dln_gdp' ...
           'ln_p' ...
           'dln_p' ...
           'ddln_p' ...
           'dtfp'...
           }';
  str_tmp = [matdir 'slist'];
  save(str_tmp,'slist');
  for iseries = 1:size(slist,1);
     ustr = char(slist(iseries));
     str_tmp = [matdir ustr];
     str_tmp1 = 'save(str_tmp,''';
     str_tmp2 = ''');';
     eval([str_tmp1 ustr str_tmp2]);
  end;
  
end;  %Load Data end;
 
  
% Load Variables and Give Standard Names 
str_tmp = [matdir 'slist'];
load(str_tmp); 
for iseries = 1:size(slist,1);
     ustr = char(slist(iseries));
     str_tmp = [matdir ustr];
     load(str_tmp);
end; 