% calibrate_level_break.m
% Sept 20, 2014, MWW
% Calibrate Level Experiments 1 and 2 .. break in level ..this also calibrates vol. break in Experiment 3
% ----------- 
clear all;
nmc = 100000;

T = 260;

% Experiments
 p = 1/260;
 delta_vec=[0.125 0.25 0.375 0.75 1 1.5 2.0 4.0]';
 
 p = 1/40;
 delta_vec=[0.0625 0.1250 0.1875 0.375 0.5 0.75 1 2]';
 
 for i = 1:size(delta_vec,1);
  delta = delta_vec(i);
  s = rand(T,nmc) < p;
  tmp = rand(T,nmc);
  sgn_ind = (tmp < 0.5) - (tmp >= 0.5);
  del_mu = (s.*sgn_ind)*delta;
  mu_T = sum(del_mu)';

  pct = [0.25;0.50;0.75];
  rslt_pctile = pctile(mu_T,pct);
  rslt_iqr = rslt_pctile(3)-rslt_pctile(1);
  fprintf('delta = %6.3f \n',delta);
  fprintf('75th percentile = %6.3f \n',rslt_pctile(3));
  fprintf('50th percentile = %6.3f \n',rslt_pctile(2));
  fprintf('25th percentile = %6.3f \n',rslt_pctile(1));
  fprintf('IQR = %6.3f \n',rslt_iqr);
  fprintf('\n');
 end;
  
