function [x_is,xbar_oos,bis,boosvec,mu_is_T,muv_oos_T] = dgp_gen_I1b_discrete(ch11,ch22_1,reg_coef,p,sz,n);

%This function calculates 1 insample draw of size T_mc and n oos draws for the mean of length T_oos.
%I0 model with I0 break in mean. p is prob of break and sz is size

 T_mc = size(ch11,1);
 T_oos = size(ch22_1,1);
 e = randn(T_mc,1);
 u_is = ch11'*e;
 reg_u = reg_coef*u_is;
 reg_e = ch22_1'*randn(T_oos,n);
 u_oos = repmat(reg_u,1,n) + reg_e;
 
 p_is = rand(T_mc,1) < p;
 p_oos = rand(T_oos,n) < p;
 
 tmp = rand(T_mc,1);
 sgn_ind = (tmp < 0.5) - (tmp >= 0.5);
 del_mu = (p_is.*sgn_ind)*sz;
 mu_is = cumsum(del_mu);
 x_is = mu_is + u_is;
 mu_is_T = mu_is(T_mc);
 
 tmp = rand(T_oos,n);
 sgn_ind = (tmp < 0.5) - (tmp >= 0.5);
 del_mu = (p_oos.*sgn_ind)*sz;
 mu_oos = cumsum(del_mu) + mu_is_T;
 x_oos = mu_oos + u_oos;
 xbar_oos = mean(x_oos)';
 muv_oos_T = mu_oos(end,:)';
 
 bis = sum(p_is) > 0;
 boosvec = (sum(p_oos) > 0)';
              
end

