function [x_is,xbar_oos] = dgp_ppt(T_is,T_oos,n);

%This function calculates 1 insample draw of size T_is and n oos draws for the mean of length T_oos.
%  PPT ReStud (2006) Model -- Parameters given below
%  PPT Table 5

b_1 = 0.165;  % alpha*phi
b_2 = 0.916;  % 1-phi
vb_1 = 0.273;
vb_2 = 0.179;
v_0 = 0.884;
d_0 = 0.050;
%PT (2011) Table 4;
a_0 = 34.77;
b_0 = 0.81;

% Use Notation from PPT;
phi_j = 1-b_2;
alpha_j = b_1/phi_j;
var_phi = vb_2;
var_alpha = vb_1/(phi_j^2);

% Insample .. of length 2*T_is -- then discard first T_is draws;
y = zeros(2*T_is,1);
y(1) = alpha_j;
[alpha,phi,se,pxx] = ptt_parm(alpha_j,phi_j,var_alpha,var_phi,v_0,d_0,a_0,b_0);
b0 = alpha*phi;
b1 = 1-phi;
for t = 2:2*T_is;
	s = rand(1);
	if s > pxx;  % Regime Change
	 [alpha,phi,se,pxx] = ptt_parm(alpha_j,phi_j,var_alpha,var_phi,v_0,d_0,a_0,b_0);
	 b0 = alpha*phi;
	 b1 = 1-phi;
	end;
	y(t) = b0 + b1*y(t-1) + se*randn(1);
end;
x_is = y(T_is+1:end);
b0_T = b0;
b1_T = b1;
se_T = se;
pxx_T = pxx;	
	
xbar_oos = NaN(n,1);
for i = 1:n;
	y = zeros(T_oos+1,1);
	y(1) = x_is(end);
	b0 = b0_T;
	b1 = b1_T;
	se = se_T;
	pxx = pxx_T;
	for t = 2:T_oos+1;
		s = rand(1);
	  if s > pxx;
	   [alpha,phi,se,pxx] = ptt_parm(alpha_j,phi_j,var_alpha,var_phi,v_0,d_0,a_0,b_0);
	   b0 = alpha*phi;
	   b1 = 1-phi;
	  end;
	  y(t) = b0 + b1*y(t-1) + se*randn(1);
  end;
  xbar_oos(i) = mean(y(2:end));


end
