function [u,uhat_oos,bis,boosvec,sig_iis_T,sig_oos_T] = dgp_vol_1_discrete(T_mc,T_oos,p,sz,n);;
%This function calculates 1 insample draw of size T_mc and n oos draws for the mean of length T_oos.

 u_is = randn(T_mc,1);
 u_oos = randn(T_oos,n);
 p_is = rand(T_mc,1) < p;
 p_oos = rand(T_oos,n) < p;
 
 
 tmp = rand(T_mc,1);
 sgn_ind = (tmp < 0.5) - (tmp >= 0.5);
 del_mu = (p_is.*sgn_ind)*sz;
 mu_is = cumsum(del_mu);
 mu_is_T = mu_is(T_mc);
 
 tmp = rand(T_oos,n);
 sgn_ind = (tmp < 0.5) - (tmp >= 0.5);
 del_mu = (p_oos.*sgn_ind)*sz;
 mu_oos = cumsum(del_mu) + mu_is_T;
 
 sig_is = exp(mu_is);
 sigv_mat = exp(mu_oos);
 u_is = sig_is.*u_is;
 u_oos = sigv_mat.*u_oos;
 
 uhat_oos = mean(u_oos)';
 u = u_is;
 
 bis = sum(p_is) > 0;
 boosvec = (sum(p_oos) > 0)';
 
 sig_iis_T = exp(mu_is_T);
 sig_oos_T = exp(sigv_mat(end,:))';
            
end