function [u,uhat_oos,bis,boosvec,sig_iis_T,sig_oos_T] = dgp_vol_2_discrete(T_mc,T_oos,p,sz,scl_i1,n);;
%This function calculates 1 insample draw of size T_mc and n oos draws for the mean of length T_oos.

 u1_is = randn(T_mc,1);
 u1_oos = randn(T_oos,n);
 du2_is = randn(T_mc,1);
 du2_oos = randn(T_oos,n);
 
 p_is = rand(T_mc,1) < p;
 p_oos = rand(T_oos,n) < p;
 
 tmp = rand(T_mc,1);
 sgn_ind = (tmp < 0.5) - (tmp >= 0.5);
 del_mu = (p_is.*sgn_ind)*sz;
 mu_is = cumsum(del_mu);
 mu_is_T = mu_is(T_mc);
 
 tmp = rand(T_oos,n);
 sgn_ind = (tmp < 0.5) - (tmp >= 0.5);
 del_mu = (p_oos.*sgn_ind)*sz;
 mu_oos = cumsum(del_mu) + mu_is_T;
 
 sig = scl_i1*exp(mu_is);
 sigv_mat = scl_i1*exp(mu_oos);
 du2_is = sig.*du2_is;
 du2_oos = sigv_mat.*du2_oos;
 
 u2_is = cumsum(du2_is);
 u2_oos = cumsum(du2_oos);
 u2_is_last = u2_is(end);
 u2_oos = u2_oos + u2_is_last*ones(T_oos,n);
 
 u_is = u1_is+u2_is;
 u_oos = u1_oos+u2_oos;
 
 uhat_oos = mean(u_oos)';
 u = u_is;
 
 bis = sum(p_is) > 0;
 boosvec = (sum(p_oos) > 0)';
 
 sig_iis_T = exp(mu_is_T);
 sig_oos_T = exp(sigv_mat(end,:))';
            
end