% August 30, 2015, MWW
% Set up matrices during first run of lr_main    

str_tmp = 'hfrac_vec'; load([matdir str_tmp '_' int2str(q)]);    
n_clevels = size(clevel_vec,1);
n_horizons = size(hfrac_vec,1);
clear hfrac_vec;
%------------- read in List of bcd values, gdist (prior), weigths (W), and lfds 
  % --- bcd values  
   str_theta = [matdir 'theta_mat'];
   load(str_theta);
   theta = theta_mat;      % "h" c, d values 
   % Convert h (third component of theta) into b
    b_um = sqrt(theta(:,1).*((theta(:,2).^2+ (8*pi)^2).^(-theta(:,3))));
    bcd_mat = [b_um theta(:,[2 3])];  % Ulrich's b c and d    % BCD values 
    n_bcd = size(bcd_mat,1);
    
   % --- prior
    load([matdir 'gamma_bayes']);
    gdist = gamma_bayes;        % Prior 
    
    
   % --- W weights for different levels 
    w_mat = NaN*zeros(n_bcd,n_horizons,n_clevels);
    for ic = 1:n_clevels;
      tmpc = 100*clevel_vec(ic);
      str_int_name = ['w_mat_' int2str(tmpc)];
      load([matdir str_int_name '_' int2str(q)]);
      eval(['tmp = ' str_int_name ';']);
      w_mat(:,:,ic) = tmp;
    end;
   
   % --- LFDs for different levels 
    lfd_mat = NaN*zeros(n_bcd,n_horizons,n_clevels);
    cvalue_mat = NaN*zeros(n_horizons,n_clevels);
    for ic = 1:n_clevels;
      tmpc = 100*clevel_vec(ic);
      str_int_name = ['lfd_mat_' int2str(tmpc)];
      load([matdir str_int_name '_' int2str(q)]);
      eval(['tmp = ' str_int_name ';']);
      lfd_mat(:,:,ic) = tmp;
      str_int_name = ['cvalue_' int2str(tmpc)];
      load([matdir str_int_name '_' int2str(q)]);
      eval(['tmp = ' str_int_name ';']);
      cvalue_mat(:,ic) = tmp;
    end;
    str_tmp = [mat_save_dir 'cvalue_mat_' int2str(q)];
    save(str_tmp,'cvalue_mat');
    
    
    
   %{
% --- Find bcd values that have non-zero weight in prior or LFD
    tmp = gdist;
    for ic = 1:n_clevels;
      tmp = [tmp lfd_mat(:,:,ic)];
    end;
    ii_tmp = sum((tmp > 1.0e-10),2);
    ii_bcd_use = ii_tmp > 0;
    theta = theta(ii_bcd_use == 1,:);
    bcd_mat = bcd_mat(ii_bcd_use == 1,:);
    gdist = gdist(ii_bcd_use == 1);
    lfd_mat = lfd_mat(ii_bcd_use == 1,:,:);
%}
   % --- Save these values for future use
    str_tmp = [mat_save_dir 'bcd_mat_' int2str(q)];
    save(str_tmp,'bcd_mat');
    clear bcd_mat;
    str_tmp = [mat_save_dir 'gdist_' int2str(q)];
    save(str_tmp,'gdist');
    clear gdist;
    str_tmp = [mat_save_dir 'w_mat_' int2str(q)];
    save(str_tmp,'w_mat');   
    clear w_mat;
    str_tmp = [mat_save_dir 'lfd_mat_' int2str(q)];
    save(str_tmp,'lfd_mat');   
    clear lfd_mat;
    
  
    % -- Save scalar zero for matlab sigma 
       sig_matlab_save = 0;
       str_tmp = [mat_save_dir 'sig_matlab_save_' int2str(q)];
       save(str_tmp,'sig_matlab_save');
       clear sigma_matlab_save;