% lr_sp500_summary.m
% August 31, 2015, MWW
% Summarize results from POOS experiment using daily return data
% ----------- Step 1: Set up parameters and so forth for run
clear all;
small = 1.0e-10;
  % -- File Directories 
  
  outdir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/out/';
  figdir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/fig/';
  matdir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/mat/';;
  mat_save_dir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/mat_save/';;  % Location for Saving Various Files
  
  % -- Parameters
  q = 12;                         % value of q to use 
  clevel_vec = [0.67;0.90];       % Confidence Level
  rho = 0.50;                     % Horizon fraction

  % ---- Series to use and output file
  %x_str = 'sp500_ret';
  x_str = 'sp500_sqret';
  
  str_out = [outdir x_str '_summary' '_' int2str(q) '.out'];
  fid_out = fopen(str_out,'w');
  
  str_tmp = [mat_save_dir 'Bayes_save' x_str '_' int2str(q)];
  load(str_tmp);
  str_tmp = [mat_save_dir 'MN_save' x_str '_' int2str(q)];
  load(str_tmp);
  str_tmp = [mat_save_dir 'MLE_save' x_str '_' int2str(q)];
  load(str_tmp);
  str_tmp = [mat_save_dir 'I0_save' x_str '_' int2str(q)];
  load(str_tmp);
  str_tmp = [mat_save_dir 'xbar_os_save' x_str '_' int2str(q)];
  load(str_tmp);
  str_tmp = [mat_save_dir 'X_all' x_str '_' int2str(q)];
  load(str_tmp);
  str_tmp = [mat_save_dir 'calvec' x_str '_' int2str(q)];
  load(str_tmp);
  
  ismpl = isnan(xbar_os_save)==0;
  
  Bayes_save = Bayes_save(ismpl,:);
  MN_save = MN_save(ismpl,:);
  MLE_save = MLE_save(ismpl,:);
  I0_save = I0_save(ismpl,:);
  xbar_os_save = xbar_os_save(ismpl,:);
  X_all = X_all(ismpl,:);
  calvec = calvec(ismpl);
  nobs = size(calvec,1);
  
  fprintf(fid_out,'Number of forecasts =  %7.0f\n',nobs);
  fprintf(fid_out,'Value of q: %2i \n',q);
  % Compute fraction in for each value of clevel
  for ic = 1:size(clevel_vec);
  	jj = 2*(ic-1);
  	fprintf(fid_out,'\n\n');
  	fprintf(fid_out,' Results for Confidence level: %5.2f\n',clevel_vec(ic));
  	
  	tmp = Bayes_save;
    tmp = tmp(:,jj+1:jj+2);
    tmp1 = mean((tmp(:,1) <= xbar_os_save).*(tmp(:,2) >= xbar_os_save));
    fprintf(fid_out,'    Coverage of Bayes Sets = %6.2f\n',tmp1);
    
    tmp = MN_save;
    tmp = tmp(:,jj+1:jj+2);
    tmp1 = mean((tmp(:,1) <= xbar_os_save).*(tmp(:,2) >= xbar_os_save));
    fprintf(fid_out,'    Coverage of MN Sets = %6.2f\n',tmp1);
    
    tmp = MLE_save;
    tmp = tmp(:,jj+1:jj+2);
    tmp1 = mean((tmp(:,1) <= xbar_os_save).*(tmp(:,2) >= xbar_os_save));
    fprintf(fid_out,'    Coverage of MLE Sets = %6.2f\n',tmp1);
    
    tmp = I0_save;
    tmp = tmp(:,jj+1:jj+2);
    tmp1 = mean((tmp(:,1) <= xbar_os_save).*(tmp(:,2) >= xbar_os_save));
    fprintf(fid_out,'    Coverage of I0 Sets = %6.2f\n',tmp1);
    
    % Compute fraction sets with MN = Bayes
    tmp = Bayes_save(:,jj+1:jj+2) == MN_save(:,jj+1:jj+2);
    tmp1 = sum(tmp') == 2;
    tmp2 = mean(tmp1);
    fprintf(fid_out,'    Fraction of MN sets = Bayes Sets: %6.2f\n',tmp2);
    
    % Compute a time series of in-sample means .. note: these will be the
    % midpoint of the I(0) prediction sets
    
    tmp = I0_save;
    tmp = tmp(:,jj+1:jj+2);
    xbar_is = (tmp(:,2)+tmp(:,1))/2;
    
    % Compute mean and standard deviation of xbar_oos
    xbar_oos_mean = mean(xbar_os_save);
    xbar_oos_sd = std(xbar_os_save);
    fprintf(fid_out,'    Mean of xbar_os: %6.2f\n',xbar_oos_mean);
    fprintf(fid_out,'    Std. Dev. of xbar_os: %6.2f\n',xbar_oos_sd);
    
    % Compute mean and standard deviation of xbar_oos-xbar_is
    xbar_oos_mean = mean(xbar_os_save-xbar_is);
    xbar_oos_sd = std(xbar_os_save-xbar_is);
    fprintf(fid_out,'    Mean of xbar_os-xbar_is: %6.2f\n',xbar_oos_mean);
    fprintf(fid_out,'    Std. Dev. of xbar_os-xbar_is: %6.2f\n',xbar_oos_sd);
    
    % Compute average width of prediction set
    fprintf(fid_out,'    Average length of prediction set \n');
    tmp = Bayes_save;
    tmp = tmp(:,jj+1:jj+2);
    mean_length = mean(tmp(:,2)-tmp(:,1));
    fprintf(fid_out,'       Bayes %6.2f \n',mean_length);
    
    tmp = MN_save;
    tmp = tmp(:,jj+1:jj+2);
    mean_length = mean(tmp(:,2)-tmp(:,1));
    fprintf(fid_out,'       MN %6.2f \n',mean_length);
    
    tmp = MLE_save;
    tmp = tmp(:,jj+1:jj+2);
    mean_length = mean(tmp(:,2)-tmp(:,1));
    fprintf(fid_out,'       MLE %6.2f \n',mean_length);
    
    tmp = I0_save;
    tmp = tmp(:,jj+1:jj+2);
    mean_length = mean(tmp(:,2)-tmp(:,1));
    fprintf(fid_out,'       I0 %6.2f \n',mean_length); 
    
  end;
  
   
 type(str_out);
    	
  