% lr_tb3m.m
% August 31, 2015, MWW
% POOS experiment using daily T-Bill rate data
% ----------- Step 1: Set up parameters and so forth for run
clear all;
small = 1.0e-10;
  % -- File Directories 
  
  outdir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/out/';
  figdir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/fig/';
  matdir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/mat/';;
  mat_save_dir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/Matlab/mat_save/';;  % Location for Saving Various Files
  
  % -- Parameters
  qvec = [12]';
  
  for iq = 1:size(qvec,1);
  
  q = qvec(iq);
  
                           % value of q to use 
  clevel_vec = [0.67;0.90];       % Confidence Level
  rho = 0.50;                     % Horizon fraction
  
  % -- Parameters to govern calculation of covariance matrices, grid of BCD values and so forth
 i_first = 0;  % = 1, the first time this program is used.  In this case, the program sets up various matrices
                %      (cov. matrices, BCD values, horizon fractions, etc.) that can be used for future calls.

                
% ---------- Step 2: Set up BCD parameters, Sigma matrices and so forth
  if i_first == 1;
    lr_main_setup_matrices;
  end;                
 %  ----- Read in variables
      str_tmp = 'hfrac_vec'; load([matdir str_tmp '_' int2str(q)]);    
      str_tmp = 'bcd_mat'; load([mat_save_dir str_tmp '_' int2str(q)]);    
      str_tmp = 'gdist'; load([mat_save_dir str_tmp '_' int2str(q)]);  
      str_tmp = 'cvalue_mat'; load([mat_save_dir str_tmp '_' int2str(q)]); 
      str_tmp = 'lfd_mat'; load([mat_save_dir str_tmp '_' int2str(q)]); 
      str_tmp = 'w_mat'; load([mat_save_dir str_tmp '_' int2str(q)]);
      str_tmp = 'sig_matlab_save'; load([mat_save_dir str_tmp '_' int2str(q)]);  
   % --- Some Dimensions
   n_bcd = size(bcd_mat,1);
   n_clevels = size(clevel_vec,1);
   n_horizons = size(hfrac_vec,1);
      
   % Choose sigma matrix to use;
      sigma_save = sig_matlab_save;
      
      % Save components relevant for horizon
      ii_rho = hfrac_vec == rho;
      trend = (1:1:size(hfrac_vec,1))';
      irho = trend(ii_rho==1);
      cvalue_mat = cvalue_mat(irho,:);
      lfd_mat = lfd_mat(:,irho,:);
      w_mat = w_mat(:,irho,:);
      sig_tmp = sigma_save;
      sigma_save = zeros(q+1,q+1,n_bcd);
      sigma_save(1:q,1:q,:) = sig_tmp(1:q,1:q,:);
      sigma_save(1:q,q+1,:) = sig_tmp(1:q,q+irho,:);
      sigma_save(q+1,1:q,:) = sig_tmp(q+irho,1:q,:);
      sigma_save(q+1,q+1,:) = sig_tmp(q+irho,q+irho,:);
      hfrac_vec = hfrac_vec(irho); 

% ----------- Step 3: Read in data used in analysis      
  % ---- Read in Dataset ----
  x_str = 'tb3m';
  datadir = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/data/';
  fname = [datadir 'tb3m.xlsx'];
  all_data = xlsread(fname,'a2:b16075');
  x_serdate = all_data(:,1);
  m_serdate = x2mdate(x_serdate,1);   % 1904 convention in Excel dates
  calvec = date_ser2dec(m_serdate);
  rdata = all_data(:,2);
  X_all = rdata(isnan(rdata(:,1))==0);
  calvec = calvec(isnan(rdata(:,1))==0);
  dnobs = size(calvec,1);
  plot(calvec,X_all);
 
 
  %Parameters
  T_is = 260;
  T_os = floor(rho*T_is);

  %---- Series to use and output file 
 
  nsave = 2*n_clevels;
  Bayes_save = NaN*zeros(dnobs,nsave);
  MN_save = NaN*zeros(dnobs,nsave);
  MLE_save = NaN*zeros(dnobs,nsave);
  I0_save = NaN*zeros(dnobs,nsave);
  xbar_os_save = NaN*zeros(dnobs,1);

  for t = T_is+T_os:1:dnobs;
      X_is = X_all(t-(T_is+T_os)+1:t-T_os);
      X_os = X_all(t-T_os+1:t);
      Xbar_os = mean(X_os);
      xbar_os_save(t) = Xbar_os;
      [Bayes_pred_sets,MLE_pred_sets,I0_pred_sets,MN_pred_sets] ... 
         = lr_pred_sp500(X_is,q,hfrac_vec,clevel_vec,bcd_mat,sigma_save,gdist,w_mat,lfd_mat,cvalue_mat);
      for ic = 1:n_clevels;
        jj = 2*(ic-1);
        Bayes_save(t,jj+1:jj+2) = Bayes_pred_sets(1:2,ic,1)';
        MN_save(t,jj+1:jj+2) = MN_pred_sets(1:2,ic,1)';
        MLE_save(t,jj+1:jj+2) = MLE_pred_sets(1:2,ic,1)';
        I0_save(t,jj+1:jj+2) = I0_pred_sets(1:2,ic,1)';
      end;
      tmp = t/100;
      if tmp-floor(tmp) == 0;
        toc;
        t
        tic;
      end;
  end;
  
  str_tmp = [mat_save_dir 'Bayes_save' x_str '_' int2str(q)];
  save(str_tmp,'Bayes_save');
  str_tmp = [mat_save_dir 'MN_save' x_str '_' int2str(q)];
  save(str_tmp,'MN_save');
  str_tmp = [mat_save_dir 'MLE_save' x_str '_' int2str(q)];
  save(str_tmp,'MLE_save');
  str_tmp = [mat_save_dir 'I0_save' x_str '_' int2str(q)];
  save(str_tmp,'I0_save');
  str_tmp = [mat_save_dir 'xbar_os_save' x_str '_' int2str(q)];
  save(str_tmp,'xbar_os_save');
  str_tmp = [mat_save_dir 'X_all' x_str '_' int2str(q)];
  save(str_tmp,'X_all');
  str_tmp = [mat_save_dir 'calvec' x_str '_' int2str(q)];
  save(str_tmp,'calvec');
  
  
end;