function [c,pct_actual] = t_mixture(pct,mixture,reg_xs,sigma_uu,xs_qf,q,tolerance);
% Find desired percentile by sequential bisection
n = size(mixture,1);

const = sqrt(q./(sigma_uu.*xs_qf));
const_min = min(const);

% Find CDF for y_upper and y_lower
  % Initialize y_upper and y_lower
  y_upper = 40-10*const_min;
  y_lower = -40+10*const_min;;
  
  pct_upper = -1;
  while (pct_upper < pct);
   y_upper = y_upper + 10*const_min;
   y = const.*(y_upper*ones(n,1) - reg_xs);
   cdfv = tcdf(y,q);
   pct_upper = cdfv'*mixture;
  end;
  
  pct_lower = 2;
  while (pct_lower > pct);
   y_lower = y_lower - 10*const_min;
   y = const.*(y_lower*ones(n,1) - reg_xs);
   cdfv = tcdf(y,q);
   pct_lower = cdfv'*mixture;
  end;
  
  pct_middle = 2;
  while (abs(pct_middle-pct) > tolerance);
   y_middle = (y_upper+y_lower)/2;
   y = const.*(y_middle*ones(n,1) - reg_xs);
   cdfv = tcdf(y,q);
   pct_middle = cdfv'*mixture;
   if pct_middle > pct;
      y_upper = y_middle;
   else;
      y_lower = y_middle;
   end;
  end;
  c = y_middle;
  pct_actual = pct_middle;

end