% Set up data and calendars for Quarterly data in VIC project
% 8/17/2015, mww

% ----------- Features of Data Set ---------
ns_m = 2;
ns_q = 6;
xlsname = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/data/vic4.xlsx';

% ----------- Sample Period, Calendars and so forth
% Years
nfy=1947;  
nly=2014;  
% Quarters
nfq=1; 
nlq=4; 
% Months 
nfm=1;
nlm=12;
% Quarterly Calendar Vector
nper = 4;
[dnobs_q,calvec_q,calds_q] = calendar_make([nfy nfq],[nly nlq],nper);
% Monthly Calendar Vector
nper = 12;
[dnobs_m,calvec_m,calds_m] = calendar_make([nfy nfm],[nly nlm],nper);

% --------------- Read In Monthly Data ---------------- 
% Read Data 
ndesc=1;
ncodes=0;
sheet='Monthly';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns_m,dnobs_m,ndesc,ncodes);
labelvec=descmat(:,1);
% Convert Namestrings to upper case 
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);

str='CPIAUCSL';    % CPI
str=upper(str);
j = colnumber(str,namevec);
p_cpi_m = datamat(:,j);

str='CPI_JPN';     % CPI Japan
str=upper(str);
j = colnumber(str,namevec);
p_cpi_jpn_m = datamat(:,j);

% Construct Quarterly Averages 
p_cpi_q=mtoq(p_cpi_m,calds_m,calds_q,0);
p_cpi_jpn_q=mtoq(p_cpi_jpn_m,calds_m,calds_q,0);

% --------------- Read In Quarterly Data ---------------- 
% Read Data 
ndesc=1;
ncodes=0;
sheet='Quarterly';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns_q,dnobs_q,ndesc,ncodes);
labelvec=descmat(:,1);
% Convert Namestrings to upper case 
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);

str='GDPC96';   % Get Real GDP 
str=upper(str);
j = colnumber(str,namevec);
gdp = datamat(:,j);

str='OPHNFB';   % Get Output per Hour NFB 
str=upper(str);
j = colnumber(str,namevec);
oph_nfb = datamat(:,j);

str='PCECTPI';   % Get PCE Delfator
str=upper(str);
j = colnumber(str,namevec);
p_pce = datamat(:,j);

str='POP_BEA';   % Get Population 
str=upper(str);
j = colnumber(str,namevec);
pop_bea = datamat(:,j);

str='PCECC96';   % Get Real Consumption
str=upper(str);
j = colnumber(str,namevec);
consump = datamat(:,j);

str='DTFP';   % TFP 
str=upper(str);
j = colnumber(str,namevec);
d_tfp = datamat(:,j);

% Quarterly Growth Rates and so forth
d_gdp = 400*dif(log(gdp),1);
d_cons = 400*dif(log(consump),1);
d_pop = 400*dif(log(pop_bea),1);
d_oph_nfb = 400*dif(log(oph_nfb),1);
d_pcpi = 400*dif(log(p_cpi_q),1);
d_pcpi_jpn = 400*dif(log(p_cpi_jpn_q),1);
d_ppce = 400*dif(log(p_pce),1);
d_gdp_pop = d_gdp-d_pop;
d_cons_pop = d_cons-d_pop;

calvec = calvec_q;
dnobs = dnobs_q;
calds = calds_q;
nper = 4;

% Variables to Use 
%data_set = [d_gdp_pop d_pop d_cons_pop d_tfp d_oph_nfb d_ppce d_pcpi d_pcpi_jpn];
%data_names = {'d_gdp_pop';'d_pop';'d_cons_pop';'d_tfp';'d_oph_nfb';'d_ppce';'d_pcpi';'d_pcpi_jpn'};



