% Set up data and calendars for annual data in VIC project
% 8/14/2013, mww

% ----------- Features of Data Set ---------
ns_a = 3;
ns_m = 1;
xlsname = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/data/vic_annual.xlsx';

% ----------- Sample Period, Calendars and so forth
% Years
nfy=1900;  
nly=2014;  
nfm = 1;
nlm = 12;
% Calendar Vector
nper = 1;
[dnobs,calvec,calds] = calendar_make([nfy 1],[nly 1],nper);
[dnobs_m,calvec_m,calds_m] = calendar_make([1913 1],[2014 12],12);

% --------------- Read In Annual Data ---------------- 
% Read Data 
ndesc=1;
ncodes=0;
sheet='Annual';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns_a,dnobs,ndesc,ncodes);
labelvec=descmat(:,1);
% Convert Namestrings to upper case 
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);

str='POP';    % Population 
str=upper(str);
j = colnumber(str,namevec);
popu = datamat(:,j);

str='GDP';    % GDP 
str=upper(str);
j = colnumber(str,namevec);
gdp = datamat(:,j);

str='CONS';    % consumption 
str=upper(str);
j = colnumber(str,namevec);
consump = datamat(:,j);

% --------------- Read In Monthly Data ---------------- 
% Read Data 
ndesc=1;
ncodes=0;
sheet='Monthly';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns_m,dnobs_m,ndesc,ncodes);
labelvec=descmat(:,1);
% Convert Namestrings to upper case 
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);

str='CPIAUCNS';    % Population 
str=upper(str);
j = colnumber(str,namevec);
p_cpi_m = datamat(:,j);
% Pad with 13 year of missing values;
p_cpi_m = [NaN(13*12,1);p_cpi_m];
[dnobs_m,calvec_m,calds_m] = calendar_make([nfy 1],[nly 12],12);
	
p_cpi=mtoq(p_cpi_m,calds_m,calds,0);


% Quarterly Growth Rates and so forth 
d_gdp = 100*dif(log(gdp),1);
d_cons = 100*dif(log(consump),1);
d_pop = 100*dif(log(popu),1);
d_pcpi = 100*dif(log(p_cpi),1);
d_gdp_pop = d_gdp-d_pop;
d_cons_pop = d_cons-d_pop;

