% Set up data and calendars for Quarterly returns data in VIC project
% 8/14/2013, mww

% ----------- Features of Data Set ---------
ns_m = 2;
ns_q = 0;
xlsname = '/Users/mwatson/Dropbox/VIC/ddisk_Sept_2015/data/vic_returns.xlsx';

% ----------- Sample Period, Calendars and so forth
% Years
nfy=1926;  
nly=2014;  
% Quarters
nfq=1; 
nlq=4; 
% Months 
nfm=1;
nlm=12;
% Quarterly Calendar Vector
nper = 4;
[dnobs_q,calvec_q,calds_q] = calendar_make([nfy nfq],[nly nlq],nper);
% Monthly Calendar Vector
nper = 12;
[dnobs_m,calvec_m,calds_m] = calendar_make([nfy nfm],[nly nlm],nper);

% --------------- Read In Monthly Data ---------------- 
% Read Data 
ndesc=1;
ncodes=0;
sheet='Monthly';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns_m,dnobs_m,ndesc,ncodes);
labelvec=descmat(:,1);
% Convert Namestrings to upper case 
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);

str='CPIAUCNS';    % CPI (NSA) 
str=upper(str);
j = colnumber(str,namevec);
p_cpi_m = datamat(:,j);

str='VWRET';    % CRSP VW Returns 
str=upper(str);
j = colnumber(str,namevec);
vwret_m = datamat(:,j);

% Compute Return Series 
vwret_m_real = NaN*zeros(dnobs_m,1);
vwret_m_real(2:dnobs_m) = vwret_m(2:dnobs_m)-log(p_cpi_m(2:dnobs_m)./p_cpi_m(1:dnobs_m-1));  % Real Returns at a monthly rate 

% Compound to get quarterly rates 
temp_real = NaN*zeros(dnobs_m,1);
gross_real = 1+vwret_m_real;
for i = 3:dnobs_m;
 temp_real(i) = gross_real(i)*gross_real(i-1)*gross_real(i-2); 
end;
vwret_q_real = mtoq(temp_real,calds_m,calds_q,3);
vwret_q_real = 400*log(vwret_q_real);          % Log real returns in percentage points at an annual rate 

calvec = calvec_q;
dnobs = dnobs_q;
calds = calds_q;


