
	
program mfort
	use prep
	use compute_reg
	use compute_single
	use Geweke
	use omp_lib
	use ML
	use output
	implicit none
	integer	:: i
	character(len=100)	:: dir0="c:/dropbox/SCC/output_matlab/ndata/"
	
	call rnopt(8)
	
	call openML
	
!$omp parallel do
	do i=1,50
		call rnset(20+13753*omp_get_thread_num())
	enddo
	call rnset(18000)
	
	do i=0,merge(0,11,singlerun)
		s2fmtab=s2fmtab0
		if(.not. singlerun) then
			T=118;periodfac=7;worldfactor=.false.;poosflag=.false.
			cname="baseline"
			select case(i)
			case(0)
			case(1)
				periodfac=12
				cname="q_9"
			case(2)
				periodfac=5
				cname="q_23"
			case(3)
				s2fmtab=1.5**2*s2fmtab0
				cname="fgamma15"
			case(4)
				s2fmtab=0.5**2*s2fmtab0
				cname="fgamma05"
			case(5)
				worldfactor=.true.
				cname="worldfactor"
			case(6)
				T=68
				cname="T68"
			case(7:12)
				poosflag=.true.
				T=118-(i-6)*10
				cname="poos"//convtos(T)
			end select
			q0=T/periodfac
			q=merge(7,T/periodfac+15,trialrun)
			Tmax=T+maxh; npath=T+nh
			dir=dir0
		endif
		
		print *,"starting "//trim(cname),i		
		call sets2grid
		call initFw
		call setG
		call initSFs
		call initSUs
		call loadregions
		
		call inittime

		if(trialrun) call Gcheck

		call inititerate
		call savepostdraws
		if(i==0) call run_single
!		if(poosflag) call run_single
!stop		
		call printtime
	enddo
end program