fig = figure;
plot(calvec_p,exp(yall),'LineWidth',1,'color',rgb('LightBlue'));
hold on;
  plot(calvec_p,exp(fall),'- k','LineWidth',3);
  x = calvec_p(T+1:T+100);
  x2 = [x;flipud(x)];
  z = [exp(fcst(T+1:T+100,4));flipud(exp(fcst(T+1:T+100,5)))];
  fill(x2,z,rgb('LightGray'),'EdgeColor','none');
  z = [exp(fcst(T+1:T+100,4));flipud(exp(fcst(T+1:T+100,3)))];
  fill(x2,z,rgb('DarkGray'),'EdgeColor','none');
  z = [exp(fcst(T+1:T+100,3));flipud(exp(fcst(T+1:T+100,2)))];
  fill(x2,z,rgb('DarkGray'),'EdgeColor','none');
  z = [exp(fcst(T+1:T+100,2));flipud(exp(fcst(T+1:T+100,1)))];
  fill(x2,z,rgb('LightGray'),'EdgeColor','none');
  
  plot(calvec_p,exp(fcst(:,3)),'- k','LineWidth',2);
hold off;
set(gca, 'YScale', 'log');
ylabel('2011 USD');
xlabel('Year');
xlim([1900 2130]);
title('Global Factor (f_t)');
figname = ['fcst_factor' mod_name]; 
orient landscape;
print(fig, [figdir_fcst, figname], '-dpdf','-bestfit');
close(gcf);

% Construct a Forecast Picture For each country
for ic = 1:n_c;
    yfcst = NaN(T+100,5);
    yfcst(T+1:T+100,:) = squeeze(yfcst_m_pct(T+1:T+100,ic,:));
    fig = figure;
    plot(calvec_p,exp(yall),'LineWidth',2,'color',rgb('LightBlue'));
    hold on;
      plot(calvec_p,exp(yall(:,ic)),'- r','LineWidth',3);
      x = calvec_p(T+1:T+100);
      x2 = [x;flipud(x)];
      z = [exp(yfcst(T+1:T+100,4));flipud(exp(yfcst(T+1:T+100,5)))];
      fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
      z = [exp(yfcst(T+1:T+100,4));flipud(exp(yfcst(T+1:T+100,3)))];
      fill(x2,z,rgb('Salmon'),'EdgeColor','none');
      z = [exp(yfcst(T+1:T+100,3));flipud(exp(yfcst(T+1:T+100,2)))];
      fill(x2,z,rgb('Salmon'),'EdgeColor','none');
      z = [exp(yfcst(T+1:T+100,2));flipud(exp(yfcst(T+1:T+100,1)))];
      fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
      
       plot(calvec_p,exp(yfcst(:,3)),'- r','LineWidth',3);
       plot(calvec_p,exp(fall),'- k','LineWidth',3);
       plot(calvec_p,exp(fcst(:,3)),'- k','LineWidth',2); 
   hold off;
   set(gca, 'YScale', 'log');
   ax = gca;
   ylabel('2011 USD');
   xlabel('Year');
   xlim([1900 2130]);
   str_tmp = char(country(ic));
   title(str_tmp);
   str_tmp = char(country_code(ic));
   figname = ['fcst_' str_tmp mod_name]; 
   orient landscape;
   print(fig, [figdir_fcst, figname], '-dpdf','-bestfit');
   close(gcf);
end;
    