function [ks] = ks_uniform(x)
% x is vector of data that is uniformly distributed. KS is sup over [0,1]
% of the empirical CDF of x
% Sort x
xs = sort(x);
n = size(x,1);
T = linspace((1/n),1,n)';
d1 = T-[0;xs(1:end-1)];
d2 = T-xs;
md1 = max(abs(d1));
md2 = max(abs(d2));
ks = max([md1;md2]);

end

