% Tables for MC results

clear all;
small = 1.0e-10;
big = 1.0e+8;
global datadir

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datdir = '../um_mc/';
addpath('../matlab_functions');
addpath('functions');

% List Designs
Design_lst = {'Levy';'I1001';'I1003';'I1mat';'LTU003';'LTU500';'Bsheet'};
Design_name = {'Levy-BM';'I(1) c=0.01';'I(1) c=0.03';'I(1) Matern';'J c=0.03';'J c = 0.50';'Br. Sheet'};
n_design = length(Design_lst);

% Documentation for file structure
%{
This documents the rows and cols for each method
The rows come in pairs, first entry is size, second entry is lenght of CI
The columns denote the various (m,b,q) parameters used ...

Levels:  This is OLS estimate .. 
	The rows (in pairs) are (1) SCPC, (2) C-SCPC, (3) Clustered SEs
	The columns index cluster size (m=30, 60, 120, 240)
	Note the column entries for the first 2 sets of rows are identical (no clusters).
	
ClustFE:  This is cluster fixed effect estimator 
	The rows (in pairs) are (1) Clustered SEs (2) SCPC, (3) C-SCPC
	The columns index cluster size (m=30, 60, 120, 240)

FGLS: This is the LMB-GLS estimator
	The rows (in pairs) are (1) HR (2) SCPC, (3) C-SCPC
	Their is a single column

IM: This is Ibragimov-Mueller
	There is one row (a pair)
	The columns index the number of regions (m=10, 20, 50

isodiff: This is the isotropic difference estimator
	The rows (in pairs) index (1) SCPC and (2) C-SCPC)
	The columns index the value of b for the kernel  b = (0.03, 0.06,0.09,0.12 and 0.15)

lfreq: This is the Low-pass eigenvalue Transformation
	There is one (pair) row
	The columns index q with q = (10, 20, 50)
	
lowpass: This is the high-pass eigenvalue tranformation. (Note that the label is misleading)
	There are two (pairs) rows. The first is SCPC. The second is CSCPC
	The columns index q with q = (5, 10, 20, 50, 100)

R2: This is the R2 in the levels regression
	There is a single row
	
%}

% Relevant Rows to choose from files
ols_cscpc_row = 2;    % C-SCPC
iso_cscpc_row = 2;    % C-SCPC
cfe_cscpc_row = 3;    % C-SCPC
cfe_cluster_row = 1;  % Clustered SEs
lbmgls_hr_row = 1;    % HR
lbmgls_cscpc_row = 3; % C-SCPC
lpe_row = 1;
hpe_cscpc_row = 2;
im_row = 1;

% Results for Each Method
file_str = 'lbmgls_hr';
estr = 'FGLS';
ncol = 1;
psrt = '';
p_num = NaN;
n_row = 1+2*(lbmgls_hr_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'ols_cscpc';
estr = 'levels';
ncol = 1;
psrt = '';
p_num = NaN;
n_row = 1+2*(ols_cscpc_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'iso_cscpc';
estr = 'isodiff';
ncol = 5;
psrt = 'b =';
p_num = [0.03; 0.06; 0.09; 0.12; 0.15];
n_row = 1+2*(iso_cscpc_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'cfe_cscpc';
estr = 'clustFE';
ncol = 4;
psrt = 'm = ';
p_num = [30;60;120;240];
n_row = 1+2*(cfe_cscpc_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'cfe_cluster';
estr = 'clustFE';
ncol = 4;
psrt = 'm = ';
p_num = [30;60;120;240];
n_row = 1+2*(cfe_cluster_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'lbmgls_hr';
estr = 'FGLS';
ncol = 1;
psrt = '';
p_num = NaN;
n_row = 1+2*(lbmgls_hr_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'lbmgls_cscpc';
estr = 'FGLS';
ncol = 1;
psrt = '';
p_num = NaN;
n_row = 1+2*(lbmgls_cscpc_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'lpe';
estr = 'lfreg';
ncol = 3;
psrt = 'q = ';
p_num = [10;20;50];
n_row = 1+2*(lpe_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'hpe_cscpc';
estr = 'lowpass';
ncol = 5;
psrt = 'q = ';
p_num = [5;10;20;50;100];
n_row = 1+2*(hpe_cscpc_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'im';
estr = 'IM';
ncol = 3;
psrt = 'm = ';
p_num = [10;20;50];
n_row = 1+2*(im_row-1);
make_sup_table; 

% Results for Each Method
file_str = 'r2';
estr = 'R2';
make_sup_table_r2; 