function [cv,p]=findcv_omega(omega_mat,alpha)
% Find critical value given q
%   
global GQxw
q = size(omega_mat,1)-1;

% Find Critical Value: 
% Note this is cv/sqrt(q) from paper. sqrt(q) is included at the bottom
%  

  % Find cv0 with rejection frequency >= alpha
  cv0 = tinv(1-alpha/2,q)/sqrt(q);  % Note cv0 is correct for c = infinity in mean case
  % Verify that cv0 yields p >= alpha
  i1 = 0;
  jj = 0;
  while i1 == 0
    p = rejprob(cv0,omega_mat);
    i1 = p >= alpha;
    if i1 == 0
        cv0 = cv0/2;
        jj = jj+1;
    end
    if jj > 500
     error('cv0 too small');
    end
  end
  
  cv1 = cv0;
  i1 = 0;
  while i1 == 0
     p = rejprob(cv1,omega_mat);
     if p > alpha
        cv0 = cv1;
        cv1 = cv1 + 1/sqrt(q);
     else
         i1 = 1;
     end
  end
    
  % Bisection determination of cv
  cvm = (cv0+cv1)/2;
  while (cv1-cv0) > 0.01/sqrt(q)
      cvm = (cv0+cv1)/2;
      p = rejprob(cvm,omega_mat);
      if p > alpha
        cv0 = cvm;
      else
        cv1 = cvm;
      end
  end 
   
  
  cv = cvm.*sqrt(q);
 

end

