function [bhat,tstat,cv,sig_scpc,q] = sp_reg_scpc_eta(data,parms);
% Spatial regression .. robust critical values using eta model

 ci_level = parms.ci_level;
 qmax = parms.qmax;
 rhobar = parms.rhobar;
 
 s = data.s;
 s_indicator = data.s_indicator;
 X = data.X;
 Y = data.Y;
 Z = data.Z;
 n = size(X,1);
 
 % Get distance matrix
 if s_indicator == 1
     distmat = getdistmat_euclidean(s);
 elseif s_indicator == 2
     distmat = getdistmat_lat_lon(s);
 end
 distmat = distmat/max(max(distmat));

 % Get results for SCPC
 [q,cv_scpc,r] = scpc_parms(distmat,qmax,rhobar,1-ci_level);
 
 % Compute Regression results
 bZ = Z\X;
 x = X-Z*bZ;
 scl_X = sqrt(mean(x.^2));
 x = x/scl_X;  % Normalize so that MS = 1
 
 % Find alternative critical value using eta model
 cv_eta = get_cv_eta(x,r,Z,rhobar,distmat,1-ci_level);
 
 cv.cv_scpc = cv_scpc;
 cv.cv_eta = cv_eta;
 cv.cv_max = max([cv_scpc cv_eta]);
 
 V = [x Z];
 bV = V\Y;
 ehat = Y-V*bV;
 xehat = x.*ehat;
 bx = x\Y;
 bhat = bx*scl_X;
 pc_mat = r'*xehat;
 s_scpc = sqrt(mean(pc_mat.^2));
 tstat = sqrt(n)*bx./s_scpc;
 sig_scpc = scl_X*s_scpc/sqrt(n);
 
end

