function [bhat,tstat,cv,sig_scpc,q] = sp_reg_scpc_eta(data,parms);
% Spatial regression .. robust critical values using eta model

 ci_level = parms.ci_level;
 qmax = parms.qmax;
 rhobar = parms.rhobar;
 
 s = data.s;
 s_indicator = data.s_indicator;
 X = data.X;
 Y = data.Y;
 Z = data.Z;
 n = size(X,1);
 
 % Get distance matrix
 if s_indicator == 1
     distmat = getdistmat_euclidean(s);
 elseif s_indicator == 2
     distmat = getdistmat_lat_lon(s);
 end
 distmat = distmat/max(max(distmat));
 
 

 % Get results for SCPC
 cbar_scpc = getcbar(rhobar,distmat);
 cmax = getcbar(0.00001,distmat);
 W_scpc = getW(distmat,cbar_scpc,qmax);
 omega_mat_scpc = form_omega_mat(cbar_scpc,cmax,qmax,W_scpc,distmat);
 [q,cv_scpc]=findqcv(omega_mat_scpc,1-ci_level);
 r = W_scpc(:,2:q+1); % Weights for PC
 W_scpc = W_scpc(:,1:q+1);

 % Compute Regression results
 bZ = Z\X;
 x = X-Z*bZ;
 scl_X = sqrt(mean(x.^2));
 x = x/scl_X;  % Normalize so that MS = 1
 V = [x Z];
 bV = V\Y;
 ehat = Y-V*bV;
 xehat = x.*ehat;
 bx = x\Y;
 bhat = bx*scl_X;
 pc_mat = r'*xehat;
 s_scpc = sqrt(mean(pc_mat.^2));
 tstat = sqrt(n)*bx./s_scpc;
 sig_scpc = scl_X*s_scpc/sqrt(n);
 
 % Find alternative critical value using eta model
 sgn_x = (x >= 0) - (x < 0);
 W_eta_1 = abs(x)/sqrt(n);
 tmp = (repmat(x,1,q).*r);
 btmp = V\tmp;
 tmp = tmp-V*btmp;
 W_eta_2 = repmat(sgn_x,1,q).*tmp;
 W_eta = [W_eta_1 W_eta_2];
 cbar_eta = getcbar_eta(rhobar,distmat,x);
 omega_mat_eta = form_omega_mat(cbar_eta,cmax,q,W_eta,distmat);
 [cv_eta,p_eta]=findcv(omega_mat_eta,1-ci_level,q);
 
 cv.cv_scpc = cv_scpc;
 cv.cv_eta = cv_eta;
 cv.cv_max = max([cv_scpc cv_eta]);
 
end

