% Chetty Data and I(1), I(0), etc. tests

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
dataxls = '../Data/Chetty_Mobility/Chetty_Data_1.xlsx';
addpath('../matlab_functions');
addpath('../cscpc')

%% 
% Read Data
dataxls = '../Data/Chetty_Mobility/Chetty_Data_Labels.xlsx';
[~,tmp] = xlsread(dataxls,'A2:AT2');
VariableDesc = tmp';
dataxls = '../Data/Chetty_Mobility/Chetty_Data_1.xlsx';
T = readtable(dataxls);
CZ = T{:,'CZ'};

% Get Variables
AM = T{:,'AM'};
TLFPR = T{:,'TLFPR'};
LatLon = [T{:,'Lat'} T{:,'Lon'}];
VariableNames=T.Properties.VariableNames;
State = T{:,'State'};
[Su,ia,state_id]=unique(State);

% Drop Variables from Hawaii and Alaska
ii_ak = state_id == 1;
ii_hi = state_id == 12;
ii_48 = ones(length(state_id),1)-ii_ak-ii_hi;
CZ = CZ(ii_48==1);
state_id = state_id(ii_48==1);
LatLon = LatLon(ii_48==1,:);
AM = AM(ii_48==1);
TLFPR = TLFPR(ii_48==1);

% Construct LBM-GLS Transform
iiy = 1-isnan(AM);
iix = 1-isnan(TLFPR);
ii = iiy.*iix;
AMi = AM(ii==1);
TLFPRi = TLFPR(ii==1);
s = LatLon(ii==1,:);
latlongflag = 1;
distmat = getdistmat(s,latlongflag);
 % BM covariance matrix (approximation for demeanded value)
 rho_bm = 0.999;
 c_bm = getcbar(rho_bm,distmat);
 sigdm_bm = get_sigma_dm(distmat,c_bm);

 % Construct Matrix Square Root
 sigdm_bm_sqrt = sqrt_psd(sigdm_bm);
 H = pinv(sigdm_bm_sqrt,pinv_tol);
 
 y = AMi;
 ys = (y-mean(y))./std(y);
 AMi_d = H*ys;
 
 y = TLFPRi;
 ys = (y-mean(y))./std(y);
 TLFPRi_d = H*ys;
 
 AM_d = NaN(length(AM),1);
 TLFPR_d = NaN(length(TLFPR),1);
 AM_d(ii==1)= AMi_d;
 TLFPR_d(ii==1)=TLFPRi_d;
 
 Ts=table(CZ,state_id,AM,TLFPR,AM_d,TLFPR_d);

 writetable(Ts,'Chetty_Example.xlsx');
