clear

*************************************************************
import excel "Chetty_Example.xlsx", sheet("Sheet1") firstrow
log using Chetty_Example_Figure_1_5.log, replace
***********************************
desc

gen cz1990 = CZ
gen cz = CZ
global root "/Users/mwatson/Documents/git_repos/maptile_geo_templates/build"
global out "$root/geo_templates/cz1990"


egen x = std(AM)
egen y = std(AM_d)
maptile x, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_AM_Figure_1.png, replace
maptile y, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_d_AM_Figure_5.png, replace
drop x
drop y


egen x = std(TLFPR)
egen y = std(TLFPR_d)
maptile x, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_TLFPR_Figure_1.png, replace
maptile y, geo(cz1990) geofolder($out) nquantiles(10) twopt(legend(off)) conus
 graph export Chetty_d_TLFPR_Figure_5.png, replace
drop x
drop y

egen am_level = std(AM)
egen tlfpr_level = std(TLFPR)

regress am_level tlfpr_level
regress am_level tlfpr_level,r
regress am_level tlfpr_level, cluster(state_id)

egen am_dif = std(AM_d)
egen tlfpr_dif = std(TLFPR_d)

regress am_dif tlfpr_dif
regress am_dif tlfpr_dif,r
regress am_dif tlfpr_dif, cluster(state_id)


log close