% Time Series Plotted in panel (a) of Figures 1 and 5

clear all
small = 1.0e-10;
rng(78961);

n = 250;
e = randn(n+50,2);
X = cumsum(e);
X = X(end-n+1:end,:);
t = (1:1:n)';
x = X(:,1);
y = X(:,2);

% Save as Series to be read into STATA
tt=table(t,x,y);
writetable(tt,'Time_Series_RW.xlsx');

% Plots for Figure 1
plot(t,x);
plot(t,y);

% Plots for Figure 5
dx = dif(x,1);
dy = dif(y,1);

plot(t,dx);
plot(t,dy);
