% Construct Employment Data for each year from Compustat data

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;

% -- File Directories   
matdir = 'mat/';
standir = '../Stan/FirmSize/';

% Save the employment data in a format that can be read by Stan
data_fname = [matdir 'FirmSize_top100_byYear.mat'];
load(data_fname);
emp_all = emp_largest_normalized;
yr = calvec;
yr_use = [1950 1973 1996 2019]';
yr = calvec;
k_max = 100;
emp_use = NaN(length(yr_use),k_max);
for i = 1:length(yr_use)
    yr_idx = find(yr==yr_use(i));
    emp_use(i,:) = emp_all(yr_idx,1:k_max);
end

% Save files as largest 30
str_save = [standir 'FirmSize_Data_30.xlsx'];
writematrix(emp_use(:,1:30),str_save);





