% Plot some Stan Results

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;

% include path for utilities/functions
addpath('../Matlab_Functions');

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';

% Set up figure 
% -------- Plot Results --------
ax_fs = 30;
marker_size = 0.1;
line_width1 = 3;
line_width2 = 1;
nr = 3;
nc = 4;
figure('Units', 'normalized', 'Position', [0 0 0.8 1]); % Dell Monitor

%  Get Weather Results
WeatherDamages_Stan_Results;


subplot(nr,nc,1)
plot(calvec,xi_pct_dam(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,xi_pct_dam(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_dam(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_dam(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_dam(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
ylim([0.0 1.5])
title('Weather Damages: \xi')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,2)
plot(calvec,xi_pct_norm(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,xi_pct_norm(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_norm(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_norm(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_norm(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
ylim([0.00 1.50])
xlabel('Year')
title('Weather Damages (normalized): \xi')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,3)
plot(calvec,GEV_90_pct_dam(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,GEV_90_pct_dam(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_dam(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_dam(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_dam(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
ylim([0 30])
title('Weather Damages: q_{0.9}')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,4)
plot(calvec,GEV_90_pct_norm(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,GEV_90_pct_norm(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_norm(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_norm(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_norm(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
ylim([0 30])
xlabel('Year')
title('Weather Damages (normalized): q_{0.9}')
ax = gca;
ax.FontSize = ax_fs;


iplot = 4;

% --------------------------------- Returns ---------
Returns_Stan_Results;
% -------- Plot Results --------

subplot(nr,nc,iplot+1)
plot(calvec,xi_pct_large(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,xi_pct_large(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_large(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_large(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_large(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
title('Largest Returns: \xi')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,iplot+2)
plot(calvec,xi_pct_small(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,xi_pct_small(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_small(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_small(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,xi_pct_small(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
xlabel('Year')
title('Smallest Returns: \xi')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,iplot+3)
plot(calvec,GEV_90_pct_large(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,GEV_90_pct_large(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_large(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_large(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_large(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
title('Largest Returns: q_{0.9}')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,iplot+4)
plot(calvec,GEV_90_pct_small(:,3),'- b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size)
hold on
plot(calvec,GEV_90_pct_small(:,2),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_small(:,4),': b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_small(:,1),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(calvec,GEV_90_pct_small(:,5),'-- b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim(xlim_dates)
xlabel('Year')
title('Smallest Returns: q_{0.9}')
ax = gca;
ax.FontSize = ax_fs;


iplot = 8;
% --------------------------------- City Size and Firm Size ---------
CitySize_FirmSize_Stan_Results;

marker_size = 8;

subplot(nr,nc,iplot+1)
plot(yr_cs,xi_pct_cs(:,3),'-o b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size);
hold on
plot(yr_cs,xi_pct_cs(:,2),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size);
plot(yr_cs,xi_pct_cs(:,4),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_cs,xi_pct_cs(:,1),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_cs,xi_pct_cs(:,5),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim([1890 2030])
ylim([0.0 1.00])
xticks([1900 1940 1980 2020]);
% xlabel('Year')
title('City Size: \xi')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,iplot+2)
plot(yr_fs,xi_pct_fs(:,3),'-o b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size);
hold on
plot(yr_fs,xi_pct_fs(:,2),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size);
plot(yr_fs,xi_pct_fs(:,4),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_fs,xi_pct_fs(:,1),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_fs,xi_pct_fs(:,5),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim([1945 2025])
ylim([0.0 1.0])
xticks([1950 1973 1996 2019]);
xlabel('Year')
title('Firm Size: \xi')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,iplot+3)
plot(yr_cs,GEV_90_pct_cs(:,3),'-o b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size);
hold on
plot(yr_cs,GEV_90_pct_cs(:,2),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size);
plot(yr_cs,GEV_90_pct_cs(:,4),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_cs,GEV_90_pct_cs(:,1),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_cs,GEV_90_pct_cs(:,5),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim([1890 2030])
xticks([1900 1940 1980 2020]);
% xlabel('Year')
title('City Size: q_{0.90}')
ax = gca;
ax.FontSize = ax_fs;

subplot(nr,nc,iplot+4)
plot(yr_fs,GEV_90_pct_fs(:,3),'-o b','LineWidth',line_width1,'MarkerFaceColor','blue','MarkerEdgeColor','blue','MarkerSize',marker_size);
hold on
plot(yr_fs,GEV_90_pct_fs(:,2),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size);
plot(yr_fs,GEV_90_pct_fs(:,4),':s b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_fs,GEV_90_pct_fs(:,1),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
plot(yr_fs,GEV_90_pct_fs(:,5),'--o b','LineWidth',line_width2,'MarkerEdgeColor','blue','MarkerSize',marker_size)
hold off
xlim([1945 2025])
ylim([0 8])
xticks([1950 1973 1996 2019]);
xlabel('Year')
title('Firm Size: q_{0.90}')
ax = gca;
ax.FontSize = ax_fs;

% Save 
Fig_name_str = [figdir 'Paths_all'];
saveas(gcf, [Fig_name_str '.png']);
% close the figure
close(gcf);