% Read in the Events Data and plot

clear all;
small = 1.0e-10;
pinv_tol = 1.0e-05;
big = 1.0e+8;
global datadir;
% rng(197347);

% -- File Directories   
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
datadir = '../Data/WeatherDamages/';
standir = '../Stan/WeatherDamages/';

% Read in Data
str_data = [datadir 'Events_1980_2023.xlsx'];
event_name = readmatrix(str_data,'Range','A3:A365','OutputType','string');
event_type = readmatrix(str_data,'Range','B3:B365','OutputType','string');
% Indices with drought and wildfires
ii_drought = contains(event_type,'Drought');
ii_wildfire = contains(event_type,'Wildfire');
ii_select = (ii_drought+ii_wildfire) == 0;
X = readmatrix(str_data,'Range','C3:F365');
X = X(ii_select == 1,:);
event_name = event_name(ii_select == 1);
event_type = event_type(ii_select == 1);
beg_date = X(:,1);
end_date = X(:,2);
damage = X(:,3);
damage = damage/1000;
deaths = X(:,4);
num_events = size(damage,1);

% Matrix with year and month
[dnobs,calvec,calds]=calendar_make([1980 1],[2023 6],12);
% Assign Year and month to year event .. use beginning date
yr_mth_event = zeros(num_events,2);
for i = 1:num_events
    yr = floor(beg_date(i)/10000);
    tmp = floor(beg_date(i)/100);
    mth = 100*(tmp/100 - yr);
    yr_mth_event(i,1) = yr;
    yr_mth_event(i,2) = mth;
end
% Count number of events in each month
yr_mth_numevent = zeros(dnobs,3);
for i = 1:dnobs
    yr = calds(i,1);
    mth = calds(i,2);
    iy = abs(yr_mth_event(:,1)-yr) < .001;
    im = abs(yr_mth_event(:,2)-mth) < .001;
    iym = iy.*im;
    yr_mth_numevent(i,:)=[yr mth sum(iym)];
end
max_numevent = max(yr_mth_numevent(:,3));
T = dnobs;
nobs = yr_mth_numevent(:,3);
y = -ones(max_numevent,dnobs);
for i = 1:dnobs
    yr = calds(i,1);
    mth = calds(i,2);
    iy = abs(yr_mth_event(:,1)-yr) < .001;
    im = abs(yr_mth_event(:,2)-mth) < .001;
    iym = iy.*im;
    n = sum(iym);
    if n > 0
        dam = damage(iym==1,:);
        y(1:n,i)=dam;
    end
end 

% Choose dates for analysis
ismpl = smpl(calvec,[1980 1],[2023 6],12);
calvec = calvec(ismpl==1);
nobs=nobs(ismpl==1,:);
y = y(:,ismpl==1);
T = size(nobs,1);

% Save Data
str_save = [matdir 'Disasters.mat'];
save(str_save,'y','nobs','calvec');

% Save y data
str_save = [standir 'Disasters_y.xlsx'];
writematrix(y,str_save);
str_save = [standir 'Disasters_nobs.xlsx'];
writematrix(nobs,str_save);
tau = 1.0;
tau_vec = tau*ones(T,1);
str_save = [standir 'Disasters_tau.xlsx'];
writematrix(tau_vec,str_save);

% Save Data in Excel File
% Create Table with calvec, nobs and y data
Tab = table(calvec,nobs,y');
filename = [datadir 'Disasters_All_Variables.xlsx'];
writetable(Tab,filename);

% Save Key Files for use in Matlab
fname=[matdir 'Damage_monthly_excl_drought_fires_1980_2023.mat'];
save(fname,'nobs','y','calvec','calds','dnobs');
