function [lambda,psi] = GEV_to_PGP_Parms(xi,sigma,mu,tau)
    % Compute Poission-GP parameters lambda and psi from GEV parameters xi, sigma, mu with tau give
    %
    % Note -- this assumes that xi, sigmu, mu are comformable matrices and that tau is a scalar
    psi = sigma + xi.*(tau-mu);
    lambda = (sigma./psi).^(1./xi);
    
end
