function [sigma,mu] = PGP_to_GEV_Parms(xi,lambda,psi,tau)
    % Compute GEV parameters sigma and mu from Poission-GP parameters xi, lambda, psi, tau
    %
    % Note -- this assumes that xi, lambda and psi are comformable matrices and that tau is a scalar
    sigma = (lambda.^xi).*psi;
    mu = (sigma-psi)./xi + tau;
    
end
