function [llf_vec] = llf_GEV_tv_stan(y,xsi_vec,sig_vec,mu_vec)
    % Calculate Log-likehood function for GEV model using the approximation from STAN
    % Paramters are time varying
    T = size(y,1);
    nobs = size(y,2);
    llf_vec = zeros(T,1);
    for t = 1:T
        x = y(t,:)';
        xsi = xsi_vec(t);
        sig = sig_vec(t);
        mu = mu_vec(t);
        llf_t = 0;
        tau=exp(-6.0*abs(xsi));
        for i = 1:nobs-1
           z=(x(i)-mu)/sig;
           if (1+xsi*z<tau)
			        lht=-log(tau)/xsi-(z-(tau-1)/xsi)/tau;
		       else
		        	lht=-log1p(xsi*z)/xsi;
           end
           llf_t = llf_t + (1+xsi)*lht-log(sig);
        end
        z=(x(end)-mu)/sig;
        if (1+xsi*z<tau)
		      	lht=-log(tau)/xsi-(z-(tau-1)/xsi)/tau;
		    else
			      lht=-log1p(xsi*z)/xsi;
        end
        llf_t = llf_t + (1+xsi)*lht-log(sig)-exp(lht);
        llf_vec(t) = llf_t;
    end 
end