function f = minus_llf_gev_con_xsi(x,Y,xi_con)
    % Minus log-likelihood from GEV distribution .. data are in global Y, where Y is T x k
    % Value of xsi is constrained to equal xi_con (global variable)
    small = 1.0E-10;
    big = 1.0E+8;
    T = size(Y,1);
    xi = xi_con;
    sigma = x(1);
    mu = x(2);
    if sigma <= 0
        f = big;
        return
    end
    ln_pdf = 0;
    for t = 1:T
     ln_pdf_t = llf_GEV_t(Y(t,:)',xi,sigma,mu);
     ln_pdf = ln_pdf + ln_pdf_t;
    end
    f = -ln_pdf;
    
  end