/********************************************************************/
/*              FILE: Main.h                                        */
/********************************************************************/
#ifndef ANAND_MAIN_H

#define ANAND_MAIN_H

#include "basic.h"
#include "dfg.h"
#include "datapath.h"
#include "library_patch.h"
#ifdef PHYSICAL
#include "iscalp.h"
#else
#include "scheduler.h"
#endif
#include "scm.h"
#include <netdb.h>  //added by wwang for MAXHOSTNAMELEN
//#include <GetOpt.h> deleted by wwang

/*Value used as sample period if nothing is provided*/
#define DEFAULT_SAMPLING_PERIOD 1000.0
#define DEFAULT_LAXITY_FACTOR  1.2 
/********************************************************************/
class Main {
 private:
  static const char *allowed_arguments;
  char *dfg_filename;
  char *lib_filename;
  char *vec_filename;
  
  Dfg *dataflowgraph;
  library *lib;
  Datapath *dp;
  Scm *scms;
#ifdef PHYSICAL  
  unsigned short tech;
#ifdef B_P 
  iScheduler sch;
#else
  Scheduler sch;	  
#endif  
#else
  Scheduler sch;
#endif
  float sample_constraint;
  float laxity_factor;
  int pipeline_stages;
  Boolean do_retiming;
  int num_copies;
  objective obj;
  int max_synthesis_iterations;

  //functions used by other member functions
  void print_usage(ostream & = cout);

 public:
  Main() : sch() {
    dfg_filename = NULL;
    lib_filename = NULL;
    vec_filename = NULL;
    dataflowgraph = (Dfg *)NULL;
    lib = (library *) NULL;
    dp = (Datapath *)NULL;
    scms = (Scm *)NULL;
    sample_constraint = 0.0;
    laxity_factor = DEFAULT_LAXITY_FACTOR;
    pipeline_stages = 1;
    do_retiming = F;
    num_copies = 1;
    obj = POWER;
    max_synthesis_iterations = 0;

#ifdef PHYSICAL
	tech = 1;
#endif    	

    return;
  }
  ~Main() {
    if(dataflowgraph) {
      delete dataflowgraph;
    }
    if(lib) {
      delete lib;
    }
    if(dp) {
      delete dp;
    }
    if(scms) {
      delete scms;
    }
    return;
  }
  float get_sample_constraint(void){return sample_constraint;}
  inline const objective &get_obj() {return obj;}
  inline Dfg *get_dfg() {return dataflowgraph;}
  inline Datapath *get_datapath() {return dp;}
  Scheduler &get_scheduler(void) {return sch;}
  library *get_library(void) {return lib;}

  //routines to set various fields of class Main
  inline void set_dfg(Dfg *new_dfg) {
    dataflowgraph = new_dfg;
  }
  inline void set_library(library *new_lib) {
    lib = new_lib;
  }
  inline void set_datapath(Datapath *new_dp) {
    dp = new_dp;
  }

  //prints out the header info
  void print_header(int, char **);

  //process command line arguments
  void process_arguments(int, char **);

#ifdef _SCALP_
  void extract_library_from_package (Package *);
#endif
#ifndef _SCALP_
  //parse the required files to read the DFG and LIBRARY
  //not required when compiling with FRITS
  void parse_files(void);
#endif

  //simulate the DFG and collect the scmatrices
  void sc_simulation(void);

  //perform SCALP
  void scalp(void);

  //area optimization
  void area_optimize(void);
#ifdef PHYSICAL
  void power_measurement(void);
#endif  
};
#endif
/********************************************************************/
