/********************************************************************/
/*                FILE: main.c                                      */
/********************************************************************/

#include "Main.h"
#include <time.h>
/********************************************************************/
int main(int argc, char **argv)
{
  Main *toplevel = new Main;
  time_t start, end;
  clock_t start_time, end_time;
  toplevel->print_header(argc, argv);
  toplevel->process_arguments(argc,argv);
  toplevel->parse_files();
  
  switch(toplevel->get_obj()) {
  case AREA:
    toplevel->area_optimize();
    break;
  case POWER:
    time (&start);
    start_time = clock();
    toplevel->sc_simulation();
    toplevel->scalp();
    time(&end);
    end_time = clock();
    cout<<"Time used in ms = "<<difftime(end, start)*1000.0<<endl;
    cout<<"Time used by clockticking = "<<(end_time- start_time)/933000<<endl;
    break;
  default:
    cerr << "ERROR: unknown value for design objective" << endl;
    exit(-1);
    break;
  }
  //toplevel->power_measurement();
  delete toplevel;
  return(0);
}
/********************************************************************/
