// VBIT (tm), (c) ASC Inc. All rights reserved 1992-1995
// Created and enhanced by Casper B. Stoel (CBS), 1992-1994
//  derived from old FRITS v0.5 by C.B. Stoel
// Original derived from: main.C,v 1.52 1994/12/23 16:22:32

// This code is a template of a main() function for use
// with the FRITS VHDL framework.

#include "bs_common.h"
#include "manager.h"
#include "dfg.h"
#include "libelem.h"
#include "entity.h"
#include "libpack.h"
// #include "libmanag.h"
#include "fsm.h"
#include "architec.h"
#include "datapath.h"
#include "Main.h"
#include "port.h"

STring	vhdl_extension;

void* manager;
#ifndef LICENSE
Boolean log_status;
#endif

// a temporary fix for undefined globals
Base_nn* comment_obj;
STring tmp_comment;

// global storage for a top entity port
Port* top_entity_port;

void ran_out_of_memory(GUI* gui)
{
gui->display("Out of memory or disk full; exiting prematurely\n");
exit(1);
}

// This function encapsulates package loading.

Use* load_package(GUI* gui, const char* package_name, const char* library_name = NULL)
{
Use *u;
Name *n1;
IDentifier* all = new IDentifier("all");
u=new Use;
if (!u) ran_out_of_memory(gui);
n1=new Name;
if (!n1) ran_out_of_memory(gui);
n1->set_identifier(package_name);
if ( library_name ) // library name was supplied
	{
	Name* n2;
	n2=new Name;
	if (!n2) ran_out_of_memory(gui);
	n2->set_identifier(library_name);
	n1->set_name(n2);
	}
u->set_prefix(n1);
u->set_suffix(all);
if (!(((Manager*)manager)->activate_use(u)))
	{
        gui->display("Cannot initialize '%s' database\n\n", TOOLNAME);
        gui->display("Cannot load '%s' package\n\n", package_name);
#ifdef _LICENSECHK_
//quit license server now
lic->license_return();
#endif
        exit(1);
	}
return u;
}

main(int argc, char* argv[])
{
  Manager*	management;
  GUI*		gui;
  char*		name;
  char*		ptr;
  FILE*		fin = NULL;
  STring*	filename;
  VHDL*		vhdl;
  Dfg* 		dfg;
  Main          scalp_toplevel;

  management=new Manager; 	// start a manager-object
  if (management==NULL)
    {
      gui->display("Cannot allocate memory. Fatal error.\n\n");
      exit(1);
    }

  manager=(void*) management; 	// set global pointer to management
  management->set_log(TRUE);	// turn log file on
  gui=management->get_gui();	// get pointer to GUI object

  filename=new STring;
  filename->set(argv[1]);
 
  fin=fopen(filename->get(),"r");	// first try the filename as is...
  // the file pointer 'fin' should have a non-NULL val by now if
  // fopen was successful
  if (fin==NULL)
    {
      gui->display("Cannot open input file '%s'\n\n",filename->get());
      delete management;
      exit(1);
    }

  // the user could have had his own extension
  int		i;
  const char*	cc=filename->get();
  int		l=strlen(cc)-1;
  for (i=l; i>0; i--)
    if (cc[i]=='.')	// did we find an extension?
      break;
  if (i>0)
    vhdl_extension.set(&cc[i]);
  else	// there was no extension => now default to .hdl 
    vhdl_extension.set(".hdl");

  if (!management->init_database())    // init main-vhdl-object and vhdl-object ([0])
    {	
      gui->display("Cannot initialize %s. Aborting %s. \n\n", TOOLNAME, TOOLNAME);
      delete management;
      delete name;
      exit(1);
    }
		
  gui->display("Parsing VITAL package...\n");
  load_package(gui, "vital_timing");
  gui->display("Parsing SCALPLIB library...\n");
  load_package(gui, "arith");

  name=new char[strlen(argv[1])+1];
  strcpy(name,argv[1]);

  ptr = strrchr(name, '.');
  if (ptr) *ptr='\0';	// chop off any .xxxx extension

  management->get_vhdl()->set_name("work");
  management->reset_object_nr();	// current object is now VHDL[0]
  vhdl = management->get_vhdl();
  vhdl->set_name(name);

  gui->display("\n");
  if (vhdl->file_to_mem(fin)==FALSE)	// parse error...
    {
      gui->display("Error(s) found while parsing file '%s'\n\n",filename->get());
      delete management;
      delete name;
      exit(1);
    }

  // ******************************************
  // this is where the users action code starts

  Entity *e; e=vhdl->get_entity();
  top_entity_port = e->get_port();
  Library *lib;
  Datapath* datapath;
  if ( !(lib = new Library) ) ran_out_of_memory(gui);
  lib->set_identifier("ieee");
  e->add_library(lib);
  e->add_use(management->search_package("std_logic_1164")->get_use());
  e->get_use()->outside=TRUE;
  VHDL* vhdl1 = management->get_vhdl(1);
 //vhdl1->add_entity(e);
  //vhdl1->add_architecture(e->get_architecture());

  Architecture * arch;  // new RTL architecture
  arch = new Architecture;
  if (!arch) ran_out_of_memory(gui);
  arch->set_identifier("RTL");
  Block_declaration* bd = new Block_declaration;
  if (!bd)  
    ran_out_of_memory(gui);
  else 
    arch->set_block_declaration(bd);
  Concurrent_body* cb = new Concurrent_body(arch);
  if (!cb) 
    ran_out_of_memory(gui);
  else
    arch->set_concurrent_body(cb);
  e->add_architecture(arch);
  arch->set_entity(e);
  e->link_entity_signals();

  // Extract the SCALP Dfg from the VHDL entity
  dfg = e->get_dfg();
  dfg->levelize();
  cout << "DFG has been read in..." << endl << endl;
  scalp_toplevel.set_dfg(dfg);
  scalp_toplevel.extract_library_from_package(management->search_package("arith"));

  //testing area optimization, replace with power optimization next..
  scalp_toplevel.area_optimize();

  // Extract VHDL from the SCALP datapath
  //(datapath=scalp_toplevel.get_datapath())->extract_vhdl(arch, "bit");

  // To test the FSM, without instantiating it in the architecture
  FSM *fsm;
/*
  // fsm = scalp_toplevel.get_scheduler().create_fsm(datapath);
  Entity *counter, *control;
  counter = fsm->get_counter_entity();
  management->get_vhdl(1)->add_entity(counter);
  management->get_vhdl(1)->add_architecture(counter->get_architecture());
  control = fsm->get_control_entity();
  management->get_vhdl(1)->add_entity(control);
  management->get_vhdl(1)->add_architecture(control->get_architecture());
  // add FSM to the 'arch' architecture
  fsm->create_component_instantiation(arch, "fsm");
*/
/*
if ( !(fsm = new FSM(4)) ) ran_out_of_memory(gui);
fsm->add_output("out1")->add_output("out2")->add_output("out3")->add_output("out4")->add_output("out5");
fsm->initialize();
// Test the action table
fsm->select_output("out1");
fsm->set_active_state(2)->set_active_state(3)->set_active_state(0);
fsm->select_output("out2");
fsm->set_active_state(0);
fsm->select_output("out3");
fsm->set_active_state(2)->set_active_state(1)->set_active_state(0);
fsm->select_output("out4");
fsm->set_active_state(1);
Entity *counter;
counter = fsm->get_counter_entity();
management->get_vhdl(1)->add_entity(counter);
management->get_vhdl(1)->add_architecture(counter->get_architecture());
Entity *control;
control = fsm->get_control_entity();
vhdl1->add_entity(control);
vhdl1->add_architecture(control->get_architecture());
*/
  // end test FSM

//  management->save_vhdl_to_file("scalp.out", 1); // this prints out the result

#ifdef _STANDALONEVHDL_
char *output_file;
VHDL*	v=management->get_vhdl(0);
if (!(output_file=argv[2]))
	{
	output_file=new char[strlen(name)+9];
	strcpy(output_file,name);
	strcat(output_file,".verilog");
	}

printf("//\n\n");	
printf("<<<<<<  Verilog translation of VHDL file \"%s\" being written to \"%s\"  >>>>>>>>\n\n",
	argv[1], output_file);
printf("//\n\n");	
FILE *fout=fopen(output_file, "w");
if (fout==NULL)
	{
	gui->display("Cannot open output file '%s'\n\n",output_file);
	delete management;
	exit(1);
	}
v->print_verilog(fout);
#endif /* _STANDALONEVHDL_ */

management->set_log(FALSE);	// turn log file off

delete management;
delete name;

return 0;
}

