/********************************************************************/
/*              FILE: basic.h                                       */
/********************************************************************/
#ifndef BASIC_H

#define BASIC_H

#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <values.h>
#include <sys/time.h>
#include <sys/param.h>
#include <assert.h>


#ifdef _SCALP_
#include "assuranc.h"
#endif

/* macros */
#ifndef assert
#ifndef NDEBUG
#define assert(ex) {\
    if (! (ex)) {\
        (void) fprintf(stderr,\
            "Assertion failed: file %s, line %d\n\"%s\"\n",\
            __FILE__, __LINE__, "ex");\
        (void) fflush(stdout);\
        abort();\
    }\
}
#else
#define assert(ex)
#endif
#endif

#ifndef assert_false
#ifndef NDEBUG
#define assert_false() {\
  (void)fprintf(stderr, "False Assertion: file \"%s\", line %d\n",\
                __FILE__,__LINE__);\
  abort();\
}
#else
#define assert_false()
#endif
#endif

#ifdef _SCALP_
#define assert_force(ex) 
#else
#define assert_force(ex) {\
    if (! (ex)) {\
        (void) fprintf(stderr,\
            "Assertion failed: file %s, line %d\n",\
            __FILE__, __LINE__);\
        (void) fflush(stdout);\
        abort();\
    }\
}
#endif

#ifdef _SCALP_
#define FRITS_SET_CLASS(str) set_class(str);
#define FRITS_SET_MESSAGE(str) set_message(str);
#else
#define FRITS_SET_CLASS(str)
#define FRITS_SET_MESSAGE(str)
#endif

/*Define mem_ok in stand alone mode*/
#ifndef _SCALP_
#ifndef mem_ok
#ifndef NDEBUG
#define mem_ok(ex) {\
    if (! (ex)) {\
        (void) fprintf(stderr,\
            "ERROR: Ran out of memory: file %s, line %d\n",\
            __FILE__, __LINE__);\
        (void) fflush(stdout);\
        abort();\
    }\
}
#else /*NDEBUG*/
#define mem_ok(ex) ex
#endif /*NDEBUG*/
#endif /*mem_ok*/
#endif /*_SCALP_*/

#define CEIL(dblval) ((int)ceil((double)(dblval)))
#define FLOOR(dblval) ((int)floor((double)(dblval)))
#define GETBIT(val,pos) (((val) >> (pos)) & 0x1)
#define HUGEINT MAXINT
#define HUGEFLOAT MAXFLOAT
#define ABS(x) (((x)>=0)?(x):(-(x)))
#define LOG2(x) ((log((x)))/(log(2.0)))

#ifndef MAX
#define MAX(a, b) (((a) >= (b))? (a) : (b))
#endif

#ifndef MIN // added by wwang on 9/24/01 
#define MIN(a, b) (((a) <= (b))? (a) : (b))
#endif

#ifndef _SCALP_
typedef enum boolean_type {
 F = 0,
 T = 1
} Boolean;
#endif

#define IN1 1
#define IN2 2
#define OUT1 3
#define REGIN 1
#define REGOUT 2
#define LE 4
#define MUXOUT 1

extern FILE *anand_fopen(char *, char *);
extern FILE *anand_fclose(FILE *);
#endif  /* BASIC_H */

