/********************************************************************/
/*              FILE: dpelemnt.C                                    */
/* Contains an implementation of a Datapath_element class	    */
/********************************************************************/

#include "dpelemnt.h"
#include "net.h"

/********************************************************************/
//connect one of the Datapath_element's ports to a net - BY ORDER
// Note: nets member is a 0-based array, and port_num is 1-based
void Datapath_element::connect_to_net(Net *new_net, const int port_num)
{
  FRITS_SET_MESSAGE("connect_to_net");
  assert(new_net);
  assert(port_num > 0 && port_num <= nets.get_size());
  if ( nets[port_num-1] ) 
    nets[port_num-1]->disconnect_from_port(this, port_num);
  new_net->connect_to_port(this, port_num);
  nets[port_num-1] = new_net;
  return;
}

/********************************************************************/
//disconnect one of the Datapath_element's ports from a net - BY ORDER
// Note: nets member is a 0-based array, and port_num is 1-based
void Datapath_element::disconnect_from_net(Net *old_net, const int port_num)
{
  FRITS_SET_MESSAGE("disconnect_from_net");
  assert(old_net != NULL);
  assert(nets[port_num-1] == old_net);
  assert(port_num > 0 && port_num <= nets.get_size());
  nets[port_num-1]->disconnect_from_port(this, port_num);
  nets[port_num-1] = NULL;  //disconnect from net
  return;
}

/********************************************************************/
//connect one of the Datapath_element's ports to a net - BY NAME
void Datapath_element::connect_to_net(Net *new_net, const char* port_name)
{
  FRITS_SET_MESSAGE("connect_to_net");
  assert(new_net != NULL && port_name != NULL);
  List_iterator<Port_map_by_name*> net_list_iterator;
  FOR_EACH_LISTNODE(nets_list, net_list_iterator) {
    if( !strcmp(net_list_iterator.get_item()->port_name, port_name) ) {
// HACK: see connect_to_net above      !!assert(F);!!
      net_list_iterator.get_item()->net->disconnect_from_port(this, port_name);
      disconnect_from_net(net_list_iterator.get_item()->net, port_name);
    }
  }  // make sure the port with this name is not mapped
  Port_map_by_name* pmbn;
  mem_ok(pmbn = new Port_map_by_name(new_net, port_name));
  nets_list.append(pmbn);
  new_net->connect_to_port(this, port_name);
  return;
}

/********************************************************************/
//disconnect one of the Datapath_element's ports from a net - BY NAME
void Datapath_element::disconnect_from_net(Net *old_net, const char* port_name)
{
  FRITS_SET_MESSAGE("disconnect_from_net");
  assert(old_net != NULL);
  assert(port_name != NULL);
  List_iterator<Port_map_by_name*> net_list_iterator;
  Boolean found = F;
  Port_map_by_name* pmbn;
  FOR_EACH_LISTNODE(nets_list, net_list_iterator) {
    pmbn = net_list_iterator.get_item();
    if ( pmbn->net == old_net && !strcmp(pmbn->port_name, port_name) ) {
      found = T;
      break;
    }
  }  // make sure the port with this name is not mapped
  assert(found);
  old_net->disconnect_from_port(this, port_name);
  nets_list.remove(pmbn);
  return;
}
/********************************************************************/
// Searches a net by a port name. Requires a symbol table.
Net* Datapath_element::get_net(const char* port_name)
{
  List_iterator<Port_map_by_name *> pmbn_iterator;
  FOR_EACH_LISTNODE(nets_list, pmbn_iterator) {
    if ( !strcmp(pmbn_iterator.get_item()->port_name, port_name) )
      return pmbn_iterator.get_item()->net;
  } /* FOR */
  return NULL;
}
/********************************************************************/
#ifdef _SCALP_
Component_instantiation *Datapath_element::create_component_instantiation(Architecture* arch, const char* label)
{
  set_message("create_component_instantiation");
  Component_instantiation* compinst;
  Name* compname;
  Generic_map* genmap;
  Port_map* portmap;
  Association_element* assoelem;
  Formal_designator* fd;
  Actual_designator* ad;
  SigVarCon* net;
  int i = 0;
  List_iterator<Library_element_port *> portlist_iterator;
  mem_ok(compinst = new Component_instantiation);
  compinst->set_identifier(label);
  mem_ok(compname = new Name);
  Net* n;
#ifdef _OLD_LIBRARY_
  compname->set_identifier(library_element->get_frits_libelement()->get_name());
#else
  compname->set_identifier(library_element->get_name());
#endif
  compinst->set_component_name(compname);

  // We will create a Port_map here, Generic_map will have to be postponed
  // until we figure out what generics we have to pass to components.
  assert(library_element->number_of_ports() == nets.get_size());
  mem_ok(portmap = new Port_map);

  // First, map data ports, then control ports, according to the sequence of 'nets'
#ifdef _OLD_LIBRARY_
  FOR_EACH_LISTNODE(library_element->get_frits_libelement()->data_ports, portlist_iterator) {
#else
  FOR_EACH_LISTNODE(library_element->data_ports, portlist_iterator) {
#endif
    if ( i < 3 ) assert(nets[i]);
    if (nets[i]) {
      mem_ok(assoelem = new Association_element);
      mem_ok(fd = new Formal_designator);
      mem_ok(ad = new Actual_designator);
      fd->set_name(portlist_iterator.get_item()->get_name());
      assoelem->set_formal_designator(fd);
      arch->st_search(nets[i]->get_name(), (FRITS_object*&)net);
      assert(net);  // net exists in the architecture
      ad->set_actual_object(net); 
      assoelem->set_actual_designator(ad);
      portmap->add_association_element(assoelem);
    }
    i++;
  }

#ifdef _OLD_LIBRARY_
  FOR_EACH_LISTNODE(library_element->get_frits_libelement()->control_ports, portlist_iterator) {
#else
  FOR_EACH_LISTNODE(library_element->control_ports, portlist_iterator) {
#endif
    mem_ok(assoelem = new Association_element);
    mem_ok(fd = new Formal_designator);
    mem_ok(ad = new Actual_designator);
    fd->set_name(portlist_iterator.get_item()->get_name());
    assoelem->set_formal_designator(fd);
    if ( nets[i] && nets[i]->get_name() && arch->st_search(nets[i++]->get_name(), (FRITS_object*&)net) )
      ad->set_actual_object(net);  // net found, connect the port
    else
      ad->set_open(TRUE);	// leave port unconnected 
    assoelem->set_actual_designator(ad);
    portmap->add_association_element(assoelem);
  }
  compinst->set_port_map(portmap);
  return compinst;
}

#endif /*_SCALP_*/
/********************************************************************/
