/********************************************************************/
/*              FILE: dpelemnt.h                                    */
/* Contains a description of a Datapath_element class		    */
/********************************************************************/

#ifndef ANAND_DATAPATH_ELEMENT_H
#define ANAND_DATAPATH_ELEMENT_H
#include <assert.h>
#include "dfgnode.h"
#include "dfgedge.h"
#ifdef PHYSICAL
#include <list>
#include <utility>
#include <set>
#endif
#ifdef _OLD_LIBRARY_
#include "library_patch.h"
#else
#include "libelem.h"
#endif

#include "array.h"

#ifdef _SCALP_
#include "compinst.h"
#include "architec.h"
#endif
/************************Forward Declarations************************/
class Net;
/********************************************************************/
#ifdef PHYSICAL
struct fu_set_ltstr
{
        bool operator() (FUPTR fu1, FUPTR fu2) const
        {
                return ((long)fu1<(long)fu2);
        }
};
#endif
#ifdef _SCALP_
class Datapath_element : public Assurance {
#else
class Datapath_element {
#endif

protected:
#ifdef PHYSICAL
	//edges connected to this dp element.Address only;
	list<int> edge_list;
	//first of pair is address of the dp element;
	//second is the port num; 
	list<pair<int, int> > module_list;
	//Neighborhood crowd
	float _NC;
	set<FUPTR, fu_set_ltstr> neighbors;
public:
	const set<FUPTR, fu_set_ltstr> get_neighbors() const { return neighbors;}
	int get_bitwidth() {return bitwidth;}
protected:
#endif	
struct Port_map_by_name {
    Net* net;
    char* port_name;
    Port_map_by_name(void) {net = NULL; port_name = NULL;}
    Port_map_by_name(Net* n, const char* pn) {net = n; port_name = strdup(pn);}
    ~Port_map_by_name(void) { if (port_name) free(port_name); }
  };
  //Nets that each port is connected to - matches the list of ports
  Array<Net *> nets;	                  // port mapping by order
  List_ar<Port_map_by_name *> nets_list;  // port_mapping by name
  LIBELPTR library_element;               //pointer to Library_element
  int bitwidth;		                  // for parametrized library elements

  int address;                            //unique id number

  Datapath_element(LIBELPTR libelem = NULL) : nets(), nets_list() {
    FRITS_SET_CLASS("Datapath_element");
    //assert_force(libelem);
    library_element = libelem;
    address = -1;
    // Classes without the library_element (FSM) should take care of the nets
    // sizing themselves. FSM does it in FSM::initialize().
    if (library_element) {  
      nets.resize(libelem->number_of_ports());
    }
    nets.reset((Net *)NULL);
  }

  virtual ~Datapath_element() {
    Port_map_by_name *pmbn;
    List_iterator<Port_map_by_name *> pmbnscan;
    //need to free the port_map_by_name objects that are in nets_list
    FOR_EACH_LISTNODE(nets_list, pmbnscan) {
      pmbn = pmbnscan.get_item();
      assert(pmbn);
      delete pmbn;
    }
  }

public:
  //inline functions to get the fields of Datapath_element
  inline int get_address() {
    return address;
  }
  inline LIBELPTR get_libelement() {
    return library_element;
  }

  //inline functions to set the fields of Datapath_element
  inline void set_address(const int new_address) {
    FRITS_SET_MESSAGE("set_address");
    assert(new_address >= 0);
    address = new_address;
  }

  // So that one knows how many he is dealing with
  virtual int get_number_of_nets(void)	{
    return nets_list.get_size() ? nets_list.get_size() : nets.get_size();  
    //HACK - either one, or the other. Pending improvement.
  }

  Net* get_net(const char* port_name);
  // Note: port numbering is 1-based, array of nets is 0-based.
  inline Net *get_net(const int port_num) {
	  //assert(port_num<=nets.get_size());
    return nets[port_num-1];
  }

  //connect/disconnect one of the Datapath_element's ports to a net
  void connect_to_net(Net *new_net, const int port_num);
  void disconnect_from_net(Net *old_net, const int port_num);
  void connect_to_net(Net *new_net, const char* port_name);
  void disconnect_from_net(Net *old_net, const char* port_name);
  virtual const char* get_id(void) {return "Datapath_element";};

#ifdef _SCALP_
  // Creates a component instantiation for mapping to VHDL.
  // The instantiation gets 'label'.
  virtual Component_instantiation* create_component_instantiation(Architecture* arch, const char* label);
#endif
};
/********************************************************************/
#endif /* ANAND_DATAPATH_ELEMENT_H */
