/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */
/*
///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>
*/

%{
#include "basic.h"
#include "list_ar.h"
#include "array.h"
#include "dfg.h"
%}

%start cdfg

%token INPUT
%token OUTPUT
%token DFGDELAY
%token CONST
%token NAME
%token BIT_WIDTH
%token OPER_ADD
%token OPER_SUB
%token OPER_MUL
%token OPER_DIV
%token OPER_AND
%token OPER_OR
%token OPER_XOR
%token OPER_NOTEQ
%token OPER_NOT
%token OPER_GT
%token OPER_LT
%token OPER_EQ
%token OPER_SEL
%token OPER_LW
%token OPER_SW
%token <val> NUMBER
%token <charptr> IDENTIFIER

%union {
  char charptr[MAXSTRLEN];     /*to pass identifiers*/
  int  val;                    /*to pass integers*/
  Operator func;               /*to pass node types*/
}

%type <func> opertype;
%type <func> memopertype;
%%

cdfg : 
{
#ifdef DFGPARSE_DEBUG
  cout << "BEGIN PARSING CDFG..." << endl << endl;
#endif
  //we assume an empty CDFG at the beginning
  assert(nodecount == 0);
}
lines
{
#ifdef DFGPARSE_DEBUG
  cout << "END PARSING CDFG..." << endl << endl;
#endif
  yyin = anand_fclose(yyin);
};

lines : line
      | lines line;

line : INPUT IDENTIFIER
{
  EDGEPTR tmpedge;
#ifdef DFGPARSE_DEBUG
  cout << "INPUT " << $2 << endl;
#endif
  tmpedge = search_edge($2);
  if(tmpedge) {
    dfgparse_checkedge(tmpedge, T);
  } else {
    //add edge to the dfg
    tmpedge = new EDGE;
    tmpedge->set_name($2);
    add_edge(tmpedge);
  }
  dfgparse_add_inputedge(tmpedge, PI);
}
     | OUTPUT IDENTIFIER
{
  EDGEPTR tmpedge;

#ifdef DFGPARSE_DEBUG
  cout << "OUTPUT " << $2 << endl;
#endif
  tmpedge = search_edge($2);
  if(tmpedge) {
    dfgparse_checkedge(tmpedge, F);
  } else {
    //add a new edge to the dfg
    tmpedge = new EDGE;
    tmpedge->set_name($2);
    add_edge(tmpedge);
  }

  if(outputs.find(tmpedge)) {
    cerr << "Output " <<  tmpedge << " redefined at line " << yylineno << endl;
    yyerror("Illegal CDFG structure");
  }
  //add tmpedge to the output list
  outputs.append(tmpedge);
  tmpedge->po = T;
}
     | DFGDELAY IDENTIFIER IDENTIFIER NUMBER
{
  EDGEPTR tmpedge1,tmpedge2;

#ifdef DFGPARSE_DEBUG
  cout << " DELAY " << $2 << $3 << $4 << endl;
#endif
  tmpedge1 = search_edge($2);
  if(tmpedge1) {
    dfgparse_checkedge(tmpedge1, F);
  } else {
    //add a new edge to the dfg
    tmpedge1 = new EDGE;
    tmpedge1->set_name($2);
    add_edge(tmpedge1);
  }

  tmpedge1->loopout = T;
  if(loopouts.find(tmpedge1)) {
    cerr << "Loopout " <<  tmpedge1 << " redefined at line "
      << yylineno << endl;
    yyerror("Illegal CDFG structure");
  }
  //add tmpedge1 to the loopout list
  loopouts.append(tmpedge1);

  tmpedge2 = search_edge($3);
  if(tmpedge2) {
    dfgparse_checkedge(tmpedge2, T);
  } else {
    //add a new edge to the dfg
    tmpedge2 = new EDGE;
    tmpedge2->set_name($3);
    add_edge(tmpedge2);
  }
  //add tmpedge2 to the loopin list
  dfgparse_add_inputedge(tmpedge2, LOOPIN);

  //link the loopin-loopout pair using the loopin_link and loopout_link fields
  tmpedge1->set_loopin_link(tmpedge2);
  tmpedge2->set_loopout_link(tmpedge1);

  //delay of anything but 1 not implemented currently
  if($4 != 1) {
    cerr << "Bad delay value " << $4
      << " - only single-interation delay implemented" << endl;
    cerr << "Construct multiple-iteration delays using a cascade of single-iteration delays" << endl;
    yyerror("Illegal CDFG structure");
  }
}
     | CONST IDENTIFIER NUMBER
{
  EDGEPTR tmpedge;
#ifdef DFGPARSE_DEBUG
  cout << "CONST " << $2 << $3 << endl;
#endif
  tmpedge = search_edge($2);
  if(tmpedge) {
    dfgparse_checkedge(tmpedge, T);
  } else {
    //add edge to the dfg
    tmpedge = new EDGE;
    tmpedge->set_name($2);
    add_edge(tmpedge);
  }
  dfgparse_add_inputedge(tmpedge, CONSTANT_);
  tmpedge->value = $3;
}
     | NAME IDENTIFIER
{
#if DFGPARSE_DEBUG
  cout << "NAME " << $2 << endl;
#endif
  set_name($2);
}
     | BIT_WIDTH NUMBER
{
#ifdef DFGPARSE_DEBUG
  cout << "BIT_WIDTH " << $2 << endl;
#endif
  if($2 < 0 || $2 > MAXBITWIDTH) {
    cerr << "Bad bit width value " << $2 << endl;
    yyerror("Illegal CDFG structure");
  }
  if(bitwidth != 0) {
    cerr << "Bit width set more than once (" << $2 << ") at line "
      << yylineno << endl;
    yyerror("Illegal CDFG structure");
  }
  bitwidth = $2;
}

     | opertype IDENTIFIER IDENTIFIER IDENTIFIER IDENTIFIER IDENTIFIER
{
  NODEPTR opernode;
  EDGEPTR ctrledge, outedge, in1edge, in2edge;

#ifdef DFGPARSE_DEBUG
  cout << "OPERATION " << $2 << " : "
    << $5 << " = " << $3 << " " << $1 << " " << $4 << " ctrl:" << $6 <<endl;
#endif

  ctrledge = search_edge($6);
  if(ctrledge) {
    dfgparse_checkedge(ctrledge, F);
    //ctrledge->po = T;
    ctrledge->ce = T;
  } else {
    //add ctrledge to the cdfg
    ctrledge = new EDGE;
    ctrledge->set_name($6);
    add_edge(ctrledge);
    ctrledge->ce = T;
    //ctrledge->po = T;
  }

  outedge = search_edge($5);
  if(outedge) {
    dfgparse_checkedge(outedge, T);
  } else {
    //add outedge to the dfg
    outedge = new EDGE;
    outedge->set_name($5);
    add_edge(outedge);
  }

  opernode = search_node($2);
  if(opernode) {
    dfgparse_checknode(opernode, $1, T);
  } else {
    //add the opernode to the dfg
    opernode = new NODE;
    opernode->set_name($2);
    opernode->set_func($1);
    opernode->set_control_edge(ctrledge);
    add_node(opernode);
//    cout << "OPERATION:  " << $2 << "    Address:   "
//        <<opernode->get_address() << endl;
  }

  in1edge = search_edge($3);
  if(in1edge) {
    dfgparse_checkedge(in1edge, F);
  } else {
    //add the in1edge to the dfg
    in1edge = new EDGE;
    in1edge->set_name($3);
    add_edge(in1edge);
  }

  in2edge = search_edge($4);
  if(in2edge) {
    dfgparse_checkedge(in2edge, F);
  } else {
    //add the in2edge to the dfg
    in2edge = new EDGE;
    in2edge->set_name($4);
    add_edge(in2edge);
  }
  ctrledge->add_sink_node(opernode);
  opernode->add_output_edge(outedge);
  outedge->set_source_node(opernode);
  opernode->add_input_edge(in1edge);
  in1edge->add_sink_node(opernode);
  opernode->add_input_edge(in2edge);
  in2edge->add_sink_node(opernode);
}
     ;

     | opertype IDENTIFIER IDENTIFIER IDENTIFIER IDENTIFIER
{
  NODEPTR opernode;
  EDGEPTR outedge, in1edge, in2edge;

#ifdef DFGPARSE_DEBUG
  cout << "OPERATION " << $2 << " : "
    << $5 << " = " << $3 << " " << $1 << " " << $4 <<endl;
#endif
  outedge = search_edge($5);
  if(outedge) {
    dfgparse_checkedge(outedge, T);
  } else {
    //add outedge to the dfg
    outedge = new EDGE;
    outedge->set_name($5);
    add_edge(outedge);
  }

  opernode = search_node($2);
  if(opernode) {
    dfgparse_checknode(opernode, $1, T);
  } else {
    //add the opernode to the dfg
    opernode = new NODE;
    opernode->set_name($2);
    opernode->set_func($1);
    add_node(opernode);
    // to map the nodes to the cdfg description
//    cout << "OPERATION:  " << $2 << "    Address:   "
//         <<opernode->get_address() << endl; 
  }

  in1edge = search_edge($3);
  if(in1edge) {
    dfgparse_checkedge(in1edge, F);
  } else {
    //add the in1edge to the dfg
    in1edge = new EDGE;
    in1edge->set_name($3);
    add_edge(in1edge);
  }

  in2edge = search_edge($4);
  if(in2edge) {
    dfgparse_checkedge(in2edge, F);
  } else {
    //add the in2edge to the dfg
    in2edge = new EDGE;
    in2edge->set_name($4);
    add_edge(in2edge);
  }

  opernode->add_output_edge(outedge);
  outedge->set_source_node(opernode);
  opernode->add_input_edge(in1edge);
  in1edge->add_sink_node(opernode);
  opernode->add_input_edge(in2edge);
  in2edge->add_sink_node(opernode);
}
     ;
     | memopertype IDENTIFIER IDENTIFIER IDENTIFIER IDENTIFIER
{
  NODEPTR opernode;
  EDGEPTR outedge, in1edge, in2edge;

#ifdef DFGPARSE_DEBUG
  cout << "MEMORY OPERATION " << $2 << " : "
    << $5 << " = " << $3 << " " << $1 << " from " << $4 <<endl;
#endif
  outedge = search_edge($5);
  if(outedge) {
    dfgparse_checkedge(outedge, T);
  } else {
    //add outedge to the dfg
    outedge = new EDGE;
    outedge->set_name($5);
    add_edge(outedge);
  }

  opernode = search_node($2);
  if(opernode) {
    dfgparse_checknode(opernode, $1, T);
  } else {
    //add the opernode to the dfg
    opernode = new NODE;
    opernode->set_name($2);
    opernode->set_func($1);
    add_node(opernode);
//    cout << "OPERATION:  " << $2 << "    Address:   "
//         <<opernode->get_address() << endl;
  }

  in1edge = search_edge($3);
  if(in1edge) {
    dfgparse_checkedge(in1edge, F);
  } else {
    //add the in1edge to the dfg
    in1edge = new EDGE;
    in1edge->set_name($3);
    add_edge(in1edge);
  }

  in2edge = search_edge($4);
  if(in2edge) {
    dfgparse_checkedge(in2edge, F);
  } else {
    //add the in2edge to the dfg
    in2edge = new EDGE;
    in2edge->set_name($4);
    add_edge(in2edge);
  }

  opernode->add_output_edge(outedge);
  outedge->set_source_node(opernode);
  opernode->add_input_edge(in1edge);
  in1edge->add_sink_node(opernode);
  opernode->add_input_edge(in2edge);
  in2edge->add_sink_node(opernode);
}
     ;


opertype : OPER_ADD {$$ = PLUS_;}
     | OPER_MUL {$$ = MULT_;}
     | OPER_SUB {$$ = MINUS_;}
     | OPER_DIV {$$ = DEV_;}
     | OPER_AND {$$ = AND_;}
     | OPER_OR  {$$ = OR_;}
     | OPER_XOR {$$ = XOR_;}
     | OPER_NOTEQ {$$ = NOTEQ_;}
     | OPER_NOT {$$ = NOT_;}
     | OPER_GT {$$ = GREAT_;}
     | OPER_LT {$$ = LESS_;}
     | OPER_EQ {$$ = EQUAL_;}
     | OPER_SEL {$$ = SEL_;}
     ;

memopertype : OPER_LW {$$ = LW_;}
     | OPER_SW {$$ = SW_;}
     ;

%%
#include "dfglex.C"
/********************************************************************/
int yywrap() 
{
  /* cout << "
" << "*  Line: " << yylineno << endl; */
  return 1;
}
/********************************************************************/
void dfgparse_checknode(NODEPTR node, Operator f, Boolean defining)
{
  assert(node);

  if(defining && node->number_input_edges()) {
    //verify that node has no inputs
    cerr << "Node " <<  node << " redefined at line " << yylineno << endl;
    yyerror("Illegal CDFG structure");
    
  }
  if(node->get_func() != f) {
    cerr << "Node " <<  node << " of type " << node->get_func() <<
      " redefined as type " << f << "at line " << yylineno << endl;
    yyerror("Illegal CDFG structure");
  }
  return;
}

/********************************************************************/
void dfgparse_checkedge(EDGEPTR edge, Boolean defining)
{
  assert(edge);

  if(defining && edge->number_source_nodes()) {
    //verify that edge has no inputs
    cerr << "Edge " <<  edge << " redefined at line "
      << yylineno << endl;
    yyerror("Illegal CDFG structure");
    
  }
  return;
}

/********************************************************************/
void dfgparse_add_inputedge(EDGEPTR edge, PITYPE t)
{
  assert(edge);

#ifndef NDEBUG
  if(edge->is_pi() || edge->is_constant() || edge->is_loopin()) {
    cerr << "Edge " << edge << "already marked as PI/LOOPIN/CONSTANT_ - "
      << edge->inputtype << endl;
    yyerror("Parser internal error");
  }
#endif

  switch(t) {
  case PI:
    if(inputs.find(edge)) {
      cerr << "Input " <<  edge << " redefined at line "
	<< yylineno << endl;
      yyerror("Illegal CDFG structure");
    }
    //add edge to the input list
    inputs.append(edge);
    edge->inputtype = PI;
    break;
  case LOOPIN:
    if(loopins.find(edge)) {
      cerr << "Loopin " <<  edge << " redefined at line "
	<< yylineno << endl;
      yyerror("Illegal CDFG structure");
    }
    //add edge to the loopins list
    loopins.append(edge);
    edge->inputtype = LOOPIN;
    break;
  case CONSTANT_:
    if(constants.find(edge)) {
      cerr << "Constant " <<  edge << " redefined at line "
	<< yylineno << endl;
      yyerror("Illegal CDFG structure");
    }
    //add edge to the constants list
    constants.append(edge);
    edge->inputtype = CONSTANT_;
    break;
  default:
    cerr << "Bad value " << t << " for PITYPE in dfgparse_add_inputedge"
      << endl;
    yyerror("Parser internal error");
    break;
  }
  return;
}

/********************************************************************/

