/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

#include "dfgedge.h"

/********************************************************************/
void Dfgedge::display(ostream & output)
{
  FRITS_SET_MESSAGE("display");

  output << "EDGE: " << (void *)this << endl;
  output << "  name      = " << name << endl;
  output << "  address   = " << address << endl;
  output << "  inputtype = " << inputtype << endl;
  output << "  po        = " << po << endl;
  output << "  loopout   = " << loopout << endl;

  //display the fanin list
  output << "  source nodes: ";
  source_nodes->display(output);

  //display the fanout list
  output << "  sink nodes: ";
  sink_nodes->display(output);

  //display the loopin and loopout links
  if(loopin_link) {
    output << "  loopin link: ";
    output << loopin_link;
  }
  if(loopout_link) {
    output << "  loopout link: ";
    output << loopout_link;
  }

  output << endl;

  return;
}

/********************************************************************/
ostream &operator <<(ostream &output, const Dfgedge &edge)
{
  if (edge.name[0]) {
    output << edge.name;
  } else if (edge.inputtype == CONSTANT_) {
    output << edge.value;
  } else {
    output << "unnamed";
  }
  return(output);
}

/********************************************************************/
ostream &operator <<(ostream &output, const EDGEPTR edge)
{
  if(edge) {
    if (edge->name[0]) {
      output << edge->name;
    } else if (edge->inputtype == CONSTANT_) {
      output << edge->value;
    } else {
      output << "unnamed";
    }
  }
  return(output);
}

/********************************************************************/
EDGEPTR Dfgedge::add_sink_node(const NODEPTR node)
{
  FRITS_SET_MESSAGE("add_sink_node");
  assert(node);
  if(sink_nodes->find(node)) {
    cerr << "Node " << node
      << " being added twice to the output list of Edge " << this << endl;
    cerr << "Illegal CDFG structure" << endl;
    exit(-1);
  }
  sink_nodes->append(node);
  return(this);
}

/********************************************************************/
EDGEPTR Dfgedge::add_source_node(const NODEPTR node)
{
  FRITS_SET_MESSAGE("add_source_node");
  assert(node);
  if(source_nodes->find(node)) {
    cerr << "Node " << node
      << " being added twice to the input list of Edge " << this << endl;
    cerr << "Illegal CDFG structure" << endl;
    exit(-1);
  }
  source_nodes->append(node);
  return(this);
}

/********************************************************************/
EDGEPTR Dfgedge::delete_sink_node(const NODEPTR node)
{
  int count;
  FRITS_SET_MESSAGE("remove_sink_node");
  assert(node);
  if((count = sink_nodes->remove(node)) != 1) {
    cerr << "ERROR: Attempted to remove node " << node << " from the sink list of edge "
      << this << " that occurs " << count << " times" << endl;
    exit(-1);
  }
  return(this);
}

/********************************************************************/
void Dfgedge::copy(Dfgedge &source_edge)
{
  strcpy(name, source_edge.name);
  address = source_edge.address;
  inputtype = source_edge.inputtype;
  po = source_edge.po;
  loopout = source_edge.loopout;
  source_nodes->copy(*(source_edge.source_nodes));
  sink_nodes->copy(*(source_edge.sink_nodes));
  loopin_link = source_edge.loopin_link;
  loopout_link = source_edge.loopout_link;
  value = source_edge.value;
  birth = source_edge.birth; 
  death = source_edge.death;
  storage_unit = source_edge.storage_unit;

  return;
}
/********************************************************************/

void display_edgelist(const List_ar<EDGEPTR> &edgelst, ostream &output) {
  List_iterator<EDGEPTR> edgescan;
  register EDGEPTR edge;

  output << "List of Dfgedge *: <";
  FOR_EACH_LISTNODE(edgelst, edgescan) {
    edge = edgescan.get_item();
    output << " " << edge;
  }
  output << " >" << endl;

}
/********************************************************************/
