/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

#include "dfgnode.h"

#ifdef _SCALP_
extern const char* VHDL_ops[];
#endif

/********************************************************************/
void Dfgnode::display(ostream & output)
{

  FRITS_SET_MESSAGE("display");

  output << "NODE: " << (void *)this << endl;
  output << "  name = " << name << endl;
  output << "  address = " << address << endl;

  //display the fanin List
  output << "  fanin edges: ";
  (void) display_edgelist(*input_edges, output);

  //display the fanout List
  output << "  fanout edges: ";
  display_edgelist(*output_edges, output);
  if (control_input)
    output << "  control edge: " << control_input->get_name() << endl;
  else
    output << "  control edge: " << endl;
  output << "  birth: " << birth << endl;
  output << "  death: " << death << endl;
  //display the function
#ifdef _SCALP_
  output << "  function: " << VHDL_ops[(int)func] << endl;
#else
  output << "  function: " << func << endl;
#endif

  return;
}

/********************************************************************/
ostream &operator <<(ostream &output, const Dfgnode &node)
{
  output << node.name;
  return(output);
}

/********************************************************************/
ostream &operator <<(ostream &output, const NODEPTR node)
{
  if(node) {
    output << node->name;
  }
  return(output);
}

/********************************************************************/
ostream &operator <<(ostream &output, const Operator f)
{
  switch(f) {
  case NONE:
    output << "NONE";
    break;
  case PLUS_:
    output << "PLUS";
    break;
  case MULT_:
    output << "MULT";
    break;
  case MINUS_:
    output << "MINUS";
    break;
  case DEV_:
    output << "DEV";
    break;
  case AND_:
    output << "AND";
    break;
  case OR_:
    output << "OR";
    break;
  case XOR_:
    output << "XOR";
    break;
  case NOT_:
    output << "NOT";
    break;
  case GREAT_:
    output << "GREAT";
    break;
  case LESS_:
    output << "LESS";
    break;
  case EQUAL_:
    output << "EQUAL";
    break;
  case SEL_:
    output << "SELECT";
    break;
  default:
#ifdef _SCALP_
    output << "Ignored unsupported operator";
#endif
    assert_force(0);
  }
  return output;
}

/********************************************************************/
NODEPTR Dfgnode::add_output_edge(const EDGEPTR edge)
{

  FRITS_SET_MESSAGE("add_output_edge");

  assert(edge);
  if(output_edges->find(edge)) {
    cerr << "Edge " << edge
      << " being added twice to the output list of Node " << this << endl;
    cerr << "Illegal CDFG structure" << endl;
    exit(-1);
  }
  output_edges->append(edge);
  return(this);
}

/********************************************************************/
NODEPTR Dfgnode::set_output_edge(const EDGEPTR edge)
{

  FRITS_SET_MESSAGE("add_output_edge");

  assert(edge);
  assert(output_edges->get_size() == 0);
  output_edges->append(edge);
  return(this);
}

/********************************************************************/
NODEPTR Dfgnode::add_input_edge(const EDGEPTR edge)
{

  FRITS_SET_MESSAGE("add_input_edge");

  assert(edge);
  if(input_edges->find(edge)) {
    cerr << "Edge " << edge
      << " being added twice to the input list of Node " << this << endl;
    cerr << "Illegal CDFG structure" << endl;
    exit(-1);
  }
  input_edges->append(edge);
  return(this);
}

/********************************************************************/
NODEPTR Dfgnode::delete_input_edge(const EDGEPTR edge)
{
  int count;
  FRITS_SET_MESSAGE("remove_input_edge");
  assert(edge);
  if((count = input_edges->remove(edge)) != 1){
     cerr << "ERROR: Attempted to remove edge" << edge << " from the input list of node "
      << this << " that occurs " << count << " times" << endl;
    exit(-1);
  }
  return(this);
}

/********************************************************************/
void Dfgnode::copy(Dfgnode &source_node)
{
  strcpy(name, source_node.name);
  address = source_node.address;
  input_edges->copy(*(source_node.input_edges));
  output_edges->copy(*(source_node.output_edges));
  func = source_node.func;
  level = source_node.level;
  birth = source_node.birth;
  death = source_node.death;
  moduletype = source_node.moduletype;
  functional_unit = source_node.functional_unit;
  control_input = source_node.control_input;
  return;
}
/********************************************************************/
