/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*        FILE: cdfgnode.h                                          */
/********************************************************************/

#ifndef KAMAL_DFGNODE_H
#define KAMAL_DFGNODE_H
#include "list_ar.h"
#include "parameter.h"
#include "dfgedge.h"

#ifdef _SCALP_
#include "fritso.h"
#include "bs_common.h"
#else
enum Operator { NONE=0, 
		POWER_, ABS_, NOT_, 
		MULT_, DEV_, MOD_, REM_,
		U_PLUS_, U_MINUS_,
		PLUS_, MINUS_, CONC_,
		SLL_, SRL_, SLA_, SRA_, ROL_, ROR_, 
		EQUAL_, NOTEQ_, LESS_, LTEQ_, GREAT_, GTEQ_,
		AND_, OR_, NAND_, NOR_, XOR_, XNOR_, SEL_,
		LW_, SW_,
		AND2, OR2, LNOT_, LEQUAL_, LNOTEQ_, 
		R_AND, R_NAND, R_OR, R_NOR, R_XOR, R_XNOR };
#endif



typedef class Dfgnode *NODEPTR;
typedef class Dfgnode NODE;
#define NODENULL ((NODEPTR)0);

//forward declarations
class Dfgedge;
typedef class Dfgedge *EDGEPTR;
extern void display_edgelist(const List_ar<EDGEPTR> &, ostream &);
class Functional_unit;
typedef class Functional_unit FU;
typedef class Functional_unit *FUPTR;
/********************************************************************/
#ifdef _SCALP_
class Dfgnode : public FRITS_object, public Assurance {
#else
class Dfgnode {
#endif
  friend class Dfg;
  friend ostream &operator <<(ostream &, const Dfgnode &);
  friend ostream &operator <<(ostream &, const NODEPTR);
private:
  char name[MAXSTRLEN];
  int address;                  /*id in the nodes array*/
  List_ar<EDGEPTR> *input_edges;            /*edges incident to this node*/
  List_ar<EDGEPTR> *output_edges;           /*edges from this node*/
  Operator func;
  int level;
  //scheduling information
  int birth;
  int death;
  //module type and assignment information
  int moduletype;
  FUPTR functional_unit;
  EDGEPTR control_input; /* Null if Data node */

public:
  Dfgnode(Operator op = NONE) {
    FRITS_SET_CLASS("Dfgnode");

    name[0] = '\0';
    address = 0;
    func = op;
    level = -1;
    birth = death = -1;
    moduletype = -1;
    functional_unit = NULL;
    control_input = NULL;
    input_edges = new List_ar<EDGEPTR>;
    output_edges = new List_ar<EDGEPTR>;
  }

  ~Dfgnode() {
    delete input_edges;
    delete output_edges;
  }

  //inline routines to read the fields of a Dfgnode
  inline const char *get_name() {
    FRITS_SET_MESSAGE("get_name");
    return name;
  }
  inline List_ar<EDGEPTR> &get_input_edges() {
    FRITS_SET_MESSAGE("get_input_edges");
    return(*input_edges);
  }
  inline List_ar<EDGEPTR> &get_output_edges() {
    FRITS_SET_MESSAGE("get_output_edges");
    return(*output_edges);
  }
  inline const int number_input_edges() { //get the number of input EDGES
    FRITS_SET_MESSAGE("number_input_edges");
    return input_edges->get_size();
  }
  inline const int number_all_input_edges() { //get the number of all EDGES
    int ctrl = (control_input != NULL);
    return (input_edges->get_size() + ctrl);
  }
  inline const int number_output_edges() { //number of output EDGES
    FRITS_SET_MESSAGE("number_output_edges");
    return output_edges->get_size();
  }
  inline const int get_address() { //address of this NODE in the DFG
    FRITS_SET_MESSAGE("get_address");
    return address;
  }
  inline const Operator get_func() { //function of this NODE
    FRITS_SET_MESSAGE("get_func");
    return func;
  }
  inline const int get_level() { //level of this node in the DFG
    FRITS_SET_MESSAGE("get_level");
    return level;
  }
  inline const int get_birth() { //birth cycle of this node
    FRITS_SET_MESSAGE("get_birth");
    return birth;
  }
  inline const int get_death() { //death cycle of this node
    FRITS_SET_MESSAGE("get_death");
    return death;
  }
  inline const int get_moduletype() {
    FRITS_SET_MESSAGE("get_moduletype");
    return moduletype;
  }
  inline const FUPTR get_functional_unit() {
    FRITS_SET_MESSAGE("get_functional_unit");
    return functional_unit;
  }

  //get the output edge of the node
  //asserts the fact that every node drives exactly one edge
  inline EDGEPTR get_output_edge() {
    FRITS_SET_MESSAGE("get_output_edge");
    if(!(output_edges->get_size() == 1))
	    cout<<get_name();
    assert(output_edges->get_size() == 1);
    return((*output_edges)[0]);
  }

  //inline routines to set selected fields of a Dfgnode
  //all routines return void
  inline NODEPTR set_name(const char *newname) { //name of this NODE
    FRITS_SET_MESSAGE("set_name");
    assert(strlen(newname) < MAXSTRLEN);
    strcpy(name, newname);
    return(this);
  }

  inline NODEPTR set_func(const Operator newfunc) { //function of this NODE
    FRITS_SET_MESSAGE("set_func");
    assert(newfunc >= NONE);
    func = newfunc;
    return(this);
  }

  inline NODEPTR set_level(const int newlevel) {
    FRITS_SET_MESSAGE("set_level");
    level = newlevel;
    return(this);
  }

  inline NODEPTR set_birth(const int newbirth) { //birth cycle of this NODE
    FRITS_SET_MESSAGE("set_birth");
    birth = newbirth;
    return(this);
  }

  inline NODEPTR set_death(const int newdeath) { //death cycle of this NODE
    FRITS_SET_MESSAGE("set_death");
    death = newdeath;
    return(this);
  }

  inline NODEPTR set_moduletype(const int newmoduletype) {
    FRITS_SET_MESSAGE("set_moduletype");
    moduletype = newmoduletype;
    return(this);
  }

  inline NODEPTR set_functional_unit(FUPTR newfunctional_unit) {
    FRITS_SET_MESSAGE("set_functional_unit");
    functional_unit = newfunctional_unit;
    return(this);
  }

  inline NODEPTR set_control_edge(EDGEPTR control) {
    assert(control);
    control_input = control;
    return this;
  }

  inline EDGEPTR get_control_edge() {
    return control_input;
  }

  //remove one edge from the input edges
  NODEPTR delete_input_edge(const EDGEPTR);

  //Add an output EDGE to this NODE
  NODEPTR add_output_edge(const EDGEPTR);

  //Set the output EDGE of this NODE
  //utilizes the fact tht a node can have only 1 output edge
  NODEPTR set_output_edge(const EDGEPTR edge);

  //Add an input EDGE to this NODE
  NODEPTR add_input_edge(const EDGEPTR);

  //copy this dfgnode from another dfgnode
  void copy(Dfgnode &);

  void display(ostream & = cout);
  
};
//iteration macro for each input or output edge of a node
//node is a NODEPTR, edge_it is an edge_iterator
#define FOR_EACH_FANIN_EDGE(node, edge_it) for((edge_it).start((node)->get_input_edges()); (edge_it).not_done(); (edge_it).increment())
#define FOR_EACH_FANOUT_EDGE(node, edge_it) for((edge_it).start((node)->get_output_edges()); (edge_it).not_done(); (edge_it).increment())
/********************************************************************/
#endif
