#ifndef FLOOR_PLAN2_H_
#define FLOOR_PLAN2_H_
/*
 * Lin started Jan 26 2002
 * to make it more suitable for interconnection centric high level synthesis
 */
/*###########################################################################*/
#include "FloorPlan.h"
#include "MST.h"
/*###########################################################################*/
// Uses Rectilinear distance measure.

class FloorPlan2 :
	//public Rect<2, double>,
	//public Prints<FloorPlan2>,
	//public SChecks<FloorPlan2>,
	public FloorPlan
{
public:
	FloorPlan2(): FloorPlan(), itree_(), explore_tree_(), 
		clock_tree_sc_(), link_length_(), ready_(false) 
		{
		}
        FloorPlan2(const RVector<Rect<2, double> > & cores,
			 double max_aspect_ratio, const AssocVec<double> & tie):
                         FloorPlan(cores, max_aspect_ratio, tie),
                 link_length_(cores.size(), 0.0), itree_(),explore_tree_(),
		 ready_(false)
                  {
                         solve();
                         estimate_link_length();
                         generate_total_wire_sc();
			 clock_tree_sc_ = 0.0;
	                 return;
	          }


	FloorPlan2(const RVector<Rect<2, double> > & cores,
			const RVector<unsigned long> & clocked_cores,
	        double max_aspect_ratio, const AssocVec<double> & tie):
			 FloorPlan(cores, max_aspect_ratio, tie),
			 clocked_cores_(clocked_cores), link_length_(cores.size(), 0.0), 
			 itree_(),explore_tree_(),
			 ready_(false)
		 {
#ifndef B_P
			for(long i =0;i<tie.size();i++) {
				for(long j = i+1;j<tie.size();j++){
	       				if(tie_(i,j)>0)
						tie_(i,j)=1.0;
				}				
			}
#endif			
			add_clock_wires();
			solve();	 
			remove_clock_wires();
			estimate_link_length();
#ifndef B_P
                        for(long i =0;i<tie.size();i++) {
                           for(long j = i+1;j<tie.size();j++){
                              tie_(i,j)=tie(i,j);
			   }
			}
#endif

			generate_total_wire_sc();
			generate_clock_tree_sc();
			return;
		 }

        FloorPlan2(const RVector<Rect<2, double> > & cores,
                double max_aspect_ratio = 2.0):
		        FloorPlan(cores, max_aspect_ratio), link_length_(cores.size(), 0.0), 
			itree_(),explore_tree_(),
			ready_(false)
		{
			add_clock_wires();
			solve();
			remove_clock_wires();
			estimate_link_length();
			generate_total_wire_sc();
			generate_clock_tree_sc();
			return;
		}
	~FloorPlan2() {}
public:		
	void solve(const RVector<Rect<2, double> > & cores, 
			const RVector<unsigned long> & clocked_cores, 
			double max_aspect_ratio, const AssocVec<double> & tie ); 
	//////////////////////////////////////////////////////////////
	//for interconnect centric		
protected:
	///////////////////////////////////////////////////////////
        //Interconnection length
        AssocVec<double> link_length_;

	public:	
	AssocVec<double> & get_link_length(void) { return link_length_;}
	double link_length(unsigned long i,unsigned long j) const 
				{ return link_length_(i,j); }
	double tie(unsigned long i, unsigned long j) const 
				{ return tie_(i,j); }
	long get_tie_size(void) const { return tie_.size();}
	void set_tie(const AssocVec<double> &ties) { 
		if(tie_.size()!=ties.size()) {
			cout<<"Wooops"<<endl;
			cout<<"tie_size = "<<tie_.size()<<" ties.size = "<<ties.size()<<endl;
		}
		tie_.clear();
		tie_.resize(ties.size(),0.0);
		for(unsigned long i =0; i<tie_.size();i++){
			for(unsigned long j =i + 1; j<tie_.size(); j++){
				   tie_(i,j) = ties(i,j);
			}
		}
	}
	virtual void estimate_link_length(void);
	void print_links(ostream &os) const;

	////////////////////////////////////////////////////////////
	//For clock tree estimation
        //MST clock tree
private:
        RVector<unsigned long> clocked_cores_;
	double clock_tree_sc_;
	void add_clock_wires(); 
	void remove_clock_wires();
	void generate_clock_tree_sc(void);
public:
	double clock_tree_sc() const { return clock_tree_sc_; }
		
	
	//Estimate the total switching capacitance 
private:
	double wire_sc_;// in term of unit of the module size
public:
	double total_wire_sc(void) const { return wire_sc_+clock_tree_sc_;}
	double wire_sc() const { return wire_sc_; };
	void generate_total_wire_sc(void);
	//07212002
	//This is for dedicated interconnect
	float estimate_output_network_length(
	                RVector<unsigned long> & connected_indice );	
	//This is for a Steiner Stree style shared interconnect
	//not optimal. Trunk and Branch style.
	//vertical is to specify whether the trunk is vertical(constant x)
	// or horizontal(constant y).
	float estimate_output_network_length(
			const RVector<unsigned long> & connected_indice,
			RVector<float> & trunk_branches,
			bool vertical);
	//////////////////////////////////////////////////////////////
	//for incremental version
private:
                
        //the Slicing Tree generated by partition_recurse()
        //used in the incremental FP
        IndexTree itree_;
        ExploreTree explore_tree_;
public:
	void module_size_change( const Rect<2, double> &new_size, long index);

	virtual void solve();

protected:
	bool ready_;	
public:
	bool is_ready() { return ready_; }	
	bool set_ready(bool ready) { ready_ = ready; } 
		
};

//ostream & operator<<(ostream & os, FloorPlan2::InnerRot::Composition compos);

/*###########################################################################*/
#endif
