#include "GDFloorPlan.h"

#include <iostream>
#include <cfloat>

#include "RStd.h"
#include "RGen.h"
#include "MST.h"
#include "Epsilon.h"

RVector< Rect<2, double> >  GDFloorPlan::compute_gradient( const RVector<PRect<2, double> > & cores,
                        const AssocVec<double> & links) const 
{
	RVector< Rect<2, double> > delta(cores.size(), Rect<2, double>(0.0, 0.0));
	double wire, overlap;
	MAP(i, cores.size()) {
		wire = dLinki( i, cores,links,  X);
		overlap = dOverlapi( i, cores, X);
		delta[i][X] = 0.5*wire + 0.5*overlap; 
                wire = dLinki( i, cores, links, Y);
                overlap = dOverlapi( i, cores, Y);
                delta[i][Y] = 0.5*wire + 0.5*overlap;
	}

	return delta;
}
//To compute the overlapping gradient
//===========================================================================
double GDFloorPlan::dOverlapi( const int i, const RVector< PRect<2, double> > & cores,
                              const AXIS z) const
{
        double dOi(0);
        for(int x = 0; x < i; x++) {
                dOi +=dOverlapij( cores[i],cores[x], z);
        }
        for(int x = i + 1; x < cores.size(); x++) {
                dOi +=dOverlapij( cores[i],cores[x], z);
        }

        return dOi;
}

//===========================================================================
double GDFloorPlan::dOverlapij( const PRect<2, double> & a, 
                const PRect<2, double> & b, const AXIS z) const
{
        AXIS v;
        
        if(z==Y) v = X;
        else v = Y;
        
        double W =line_overlap(a.min_pos(v), a.max_pos(v), b.min_pos(v), b.max_pos(v)); 
        double dO = line_differential(a.min_pos(z), a.max_pos(z), b.min_pos(z), b.max_pos(z));
	if(dO<-2.0){//When one dominated another totally. Randomly pick a direction and
		    //move half of the dimension.
		double rnd = RGen::gen().flat_range_d(0.0, 1.0);
		eps_greater<double> gr;
		dO = a.rect()[z] * 0.5;
		if(gr(0.5, rnd)) {
			dO *= -1.0;
		}
	}

        return W * dO;
}

//===========================================================================
double GDFloorPlan::line_overlap(const double x1_min, const double x1_max,
                                const double x2_min, const double x2_max) const
{
        double x1min, x1max, x2min, x2max;
        if(x1_min<=x2_min){
                x1min = x1_min; x1max = x1_max;
                x2min = x2_min; x2max = x2_max;
        } else {
                x1min = x2_min; x1max = x2_max;
                x2min = x1_min; x2max = x1_max;
        }
                
        if(x1max<=x2min)
                return 0.0;
        else if(x1max>=x2max)
                return (x2max - x2min);
        else return (x1max - x2min);
}
//===========================================================================
double GDFloorPlan::line_differential(const double x1_min, const double x1_max,
                                const double x2_min, const double x2_max) const
{
        double x1min, x1max, x2min, x2max;
        double swapped;
        if(x1_min<=x2_min){
                x1min = x1_min; x1max = x1_max;
                x2min = x2_min; x2max = x2_max;
                swapped = 1.0;
        } else {
                x1min = x2_min; x1max = x2_max;
                x2min = x1_min; x2max = x1_max;
                swapped = -1.0;
        }       
        double value;
        if(x1max<x2min){  value = 0.0; }
        else if(x1max==x2min) { value = 0.5; }
        else if(x1min==x2min&&x1max<x2max) { value = 0.5; }
        else if(x1min==x2min&&x1max>x2max) { value = -0.5; }
        else if(x1min==x2min&&x1max==x2max) { value = 1.0; }
        else if(x1min<x2min&&x1max>x2max) { value = -10.0; }//should be zero
        else if(x1min<x2min&&x1max==x2max) { value = 0.5; }
        else if(x1min<x2min&&x1max<x2max) { value = 1.0; }
        else assert(0);
        
        return value * swapped; 
}
//===========================================================================
double GDFloorPlan::dLinki(const int i, const RVector< PRect<2, double> > &cores,
              const AssocVec<double> &  links, const AXIS z) const
{
        double value(0.0);
        double differential;

        for(int x = 0; x<i; x++) {
                differential = dLinkij(cores[i].pos()[z], cores[x].pos()[z]);           
                value += (differential * links(x,i));
        }
        for(int x = i + 1; x<cores.size(); x++) {
                differential = dLinkij(cores[i].pos()[z], cores[x].pos()[z]);
                value += (differential * links(x,i));
        }

        return value;
}
//===========================================================================
double GDFloorPlan::dLinkij( const double center_i, const double center_j) const
{
	if(center_i==center_j)
		return 0.0;
	else if(center_i>center_j)
		return 0.5;
	else return -0.5;
}

