#ifndef GDFLOORPLAN_H
#define GDFLOORPLAN_H

#include "RVector.h"
#include "Geom.h"
#include "AssocVec.h"
#include "Epsilon.h"


class GDFloorPlan :
	public SChecks<GDFloorPlan>,
	public Prints<GDFloorPlan>
{
private:
	double t_;
	unsigned long max_iter_;
	unsigned long max_epoch_;
	double alpha_;
	double wire_weight;
	double overlap_weight;

        typedef enum COORDINATE {X = 0, Y }  AXIS;

public:	
	unsigned long iter_;
	unsigned long epoch_;
	
	
	GDFloorPlan(double t, unsigned long max_epoch, unsigned long max_iter):
		t_(t), max_epoch_(max_epoch), max_iter_(max_iter),
		iter_(0), epoch_(0)
		{
			return;
		}

	void set_alpha(double al) { alpha_ = al; }	
	double alpha() const { return alpha_; }

	void set_wire_overlap_weight(double a, double b) { wire_weight = a/( a + b); overlap_weight = b/( a + b ); }
			
  	RVector<Rect<2, double> >  compute_gradient( const RVector<PRect<2, double> > & cores,
                        const AssocVec<double> & links) const;
protected:	
                double line_overlap(const double x1_min, const double x1_max,
                              const double x2_min, const double x2_max) const;
                double line_differential(const double x1_min, const double x1_max,
                              const double x2_min, const double x2_max) const;

                double dOverlapi( const int i, const RVector< PRect<2, double> > & cores,
                              const AXIS z) const;
                        double dOverlapij(const PRect<2, double> & a,
                                        const PRect<2, double> & b, const AXIS z) const;
                double dLinki(const int i, const RVector< PRect<2, double> > & cores,
                                const AssocVec<double> & links, const AXIS z) const;
                        double dLinkij( const double center_i,  const double center_j ) const;
};

#endif
