#ifndef SA_FLOOR_PLAN_H_
#define SA_FLOOR_PLAN_H_

/*###########################################################################*/
#include "RVector.h"
#include "Geom.h"
#include "AssocVec.h"
#include "Epsilon.h"
#include "GDFloorPlan.h"
static const int SCREEN_WIDTH = 78;
class SAFloorPlan;

/*###########################################################################*/
class SAFloorPlan :
	public GDFloorPlan,
	public PRect<2, double>,
	public SChecks<SAFloorPlan>
{
public:
	typedef PRect<2, double> super;

	SAFloorPlan(const RVector<Rect<2, double> > & cores,
		double max_aspect_ratio, const AssocVec<double> & tie,
		double heat_init = 1.0, double heat_mul = 0.9,
		double heat_add = -0.0001,
		int change_steps = 6, int halt_steps = 50);

        SAFloorPlan(const RVector<Rect<2, double> > & cores,
		const RVector<Pos<2, double> > & position, 	
                double max_aspect_ratio, const AssocVec<double> & tie,
                double heat_init = 1.0, double heat_mul = 0.9,
                double heat_add = -0.0001,
                int change_steps = 6, int halt_steps = 50);

	SAFloorPlan(const RVector<Rect<2, double> > & cores,
		double max_aspect_ratio,
		double heat_init = 1.0, double heat_mul = 0.9,
		double heat_add = -0.0001,
		int change_steps = 6, int halt_steps = 50);

	const RVector<PRect<2, double> > & core() const { return core_; }
	double area_efficiency() const { return raw_core_area_ / area(); }

// Interface
	virtual void print_to(ostream & os) const;
	virtual void self_check() const;


public:
	void gradient_decent();	
/*	
private:
	typedef enum COORDINATE {X = 0, Y }  AXIS;
private:
	RVector<double> &  compute_gradient( const RVector<PRect<2, double> > & cores, 
			const AssocVec<double> & links) const;
		double line_overlap(const double x1_min, const double x1_max,
	                      const double x2_min, const double x2_max) const;
		double line_differential(const double x1_min, const double x1_max,
                              const double x2_min, const double x2_max) const;

		double dOverlapi( const int i, const RVector< PRect<2, double> > & cores,
			      const AXIS z) const;
			double dOverlapij(const PRect<2, double> & a,
				       	const PRect<2, double> & b, const AXIS z) const; 
		double dLinki(const int i, const RVector< PRect<2, double> > & cores,
				const AssocVec<double> & links,	const AXIS z) const;
			double dLinkij( const double center_i,  const center_j ) const;
*/
private:
	void optimize();
	double wire_cost() const;
	double overlap_cost() const;
	double dist(int x, int y) const;


private:
	bool anneal();
		void generate();
			void swap_pos();
			void rotate();
			void jiggle();
			void mutual_repel();

		void calc_costs();
	        	Rect<2, double> plump(const Rect<2, double> & r) const;
			void normalize_bounding_box(PRect<2, double> & bb,
				       	RVector<PRect<2, double>  > & blocks);
			double overlap_cost(const RVector<PRect<2, double> > & cores) const;
			double overlap_cost(const PRect<2, double> & a,
					                const PRect<2, double> & b) const;

		bool evaluate();
		AssocVec<double> calc_try_raw_dist() const;
		char index_to_char(long i) const;

		double cost() const;
		double try_cost() const;

		RVector<PRect<2, double> > core_;
		double raw_core_area_;
		double max_aspect_ratio_;
		const AssocVec<double> & tie_;

		double overlap_cost_;
		double wire_cost_;
		AssocVec<double> dist_;

		double heat_;
		double heat_mul_;
		double heat_add_;

		int change_steps_;
		int halt_steps_;

		RVector<PRect<2, double> > try_core_;
		double try_wire_cost_;
		double try_overlap_cost_;
		AssocVec<double> try_dist_;
		PRect<2, double> bounding_box_;
public:
        //////////////////////////////////////////////////////////////
        //for interconnect centric              
        virtual AssocVec<double>  estimate_dist(const RVector< PRect<2, double> >  & cores) const;
        void print_links(ostream &os) const;

private:	
	double compute_wire_cost(const AssocVec<double> & links, 
		      const AssocVec<double> & distance ) const;

};

/*###########################################################################*/
void mutual_repel(PRect<2, double> & a, PRect<2, double> & b,
	double pressure);

void conform(PRect<2, double> & a, PRect<2, double> & b,
	double pressure);

#endif

