#ifndef ASSOC_VEC_H_
#define ASSOC_VEC_H_

/*###########################################################################*/
#include "RecVector.h"

#ifdef ROB_DEBUG
#	include <typeinfo>
#endif

#include <iosfwd>

/*===========================================================================*/
// Associative vector.  v(x, y) == v(y, x)

template <typename T>
class AssocVec :
	public Prints<AssocVec<T>, T, true>,
	public Clones<AssocVec<T> >,
	public Swaps<AssocVec<T> >,
	public SChecks<AssocVec<T> >
{
	typedef AssocVec<T> self;
	typedef RecVector2<T> impl;

public:
// Typedefs
	typedef typename impl::value_type value_type;
	typedef typename impl::pointer pointer;
	typedef typename impl::const_pointer const_pointer;
	typedef typename impl::iterator iterator;
	typedef typename impl::const_iterator const_iterator;
	typedef typename impl::reference reference;
	typedef typename impl::const_reference const_reference;
	typedef typename impl::size_type size_type;
	typedef typename impl::difference_type difference_type;
	typedef typename impl::allocator_type allocator_type;
	typedef typename impl::const_reverse_iterator const_reverse_iterator;
	typedef typename impl::reverse_iterator reverse_iterator;

// Construction
	virtual ~AssocVec() throw() {}
	AssocVec() : impl_() {}
	AssocVec(size_type x, const T & value) : impl_(x, x, value) {}
	AssocVec(size_type x) : impl_(x, x) {}

	virtual self & operator=(const self & a);

// Interface
	virtual void rswap(self & a) { impl_.rswap(a.impl_); }
	virtual self * clone() const { return new self(*this); }
	virtual void self_check() const;
	virtual void self_check_deep() const;

// Final
	void print_to_default(ostream & os) const;
	T & operator()(size_type x, size_type y);
	const T & operator()(size_type x, size_type y) const;

	size_type size() const { return impl_.size()[0]; }
	size_type max_size() const;
	size_type capacity() const;
	void reserve(size_type n);
	void resize(size_type new_size, const T & x);
	void resize(size_type new_size);
	bool empty() const { return impl_.empty(); }
	void clear() { impl_.clear(); }
private:
		impl impl_;
};

/*===========================================================================*/
void AssocVec_test();

/*###########################################################################*/
#include "AssocVec.cct"
#endif

