#include "BinTree.h"
#include "RVector.h"

/*###########################################################################*/
void BinTree_test() {
	BinTree<int> bt;

	MAP(x, 10) {
		BinTree<int> tmp;
		tmp.add_left(tmp.header(), 0);
		tmp.add_right(tmp.header(), 5);

		RVector<BinTree<int>::Node *> leaf_up = bt.leaf_up();
		BinTree<int>::Node * i = leaf_up.size() ? leaf_up[0] : 0;
		bt.consume_left(i, tmp);
	}

	const BinTree<int> bt3(bt);
	Rassert(bt.size() == bt3.size());
	bt.clear();
	Rassert(bt.empty());

	Rassert(! bt3.empty());

	bt3.dfs();
	bt3.bfs();
	bt3.leaf_up();

	const BinTree<int> bt2;
	BinTree<int>::const_node_vec a = bt2.dfs();
	BinTree<int>::const_node_vec b = bt2.bfs();
	BinTree<int>::const_node_vec c = bt2.leaf_up();
}
